#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin			= mxGetPr(prhs[0]);
	double *nyin		= mxGetPr(prhs[1]);
	double *nein		= mxGetPr(prhs[2]);
    double *xss 		= mxGetPr(prhs[3]);
    double *yss 		= mxGetPr(prhs[4]);
	double *parmin 		= mxGetPr(prhs[5]);
	double *nnuin 		= mxGetPr(prhs[6]);
	double *varphiin	= mxGetPr(prhs[7]);
	double *Hs  		= mxGetPr(prhs[8]);
	double *Gs 			= mxGetPr(prhs[9]);
	double *Gsp 		= mxGetPr(prhs[10]);
	double *G2sp 		= mxGetPr(prhs[11]);
	double *Psspin  	= mxGetPr(prhs[12]);
	double *dP1sspin	= mxGetPr(prhs[13]);
	double *dP2sspin	= mxGetPr(prhs[14]);

	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int ny 				= nyin[0];
	int ne 				= nein[0];
	double nnus 		= nnuin[0];
	double varphis		= varphiin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double ssigmaa		= parmin[23];
	double ssigmaz 		= parmin[24];
	double ssigmap		= parmin[25];
	double ssigmar		= parmin[26];
	double ssigmae		= parmin[27];
	double ssigmad		= parmin[28];
	double Pssp 		= Psspin[0];
	double dP1ssp 		= dP1sspin[0];
	double dP2ssp 		= dP2sspin[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n*ne,(n+ny)*ne,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n*ne,1,mxREAL);
	double *Mec_sp_s = mxGetPr(plhs[0]);
	double *Nec_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
	Mec_sp_s[1008]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mec_sp_s[6912]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mec_sp_s[7056]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mec_sp_s[8064]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[8208]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[8352]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[289]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[433]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[577]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[7057]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[7201]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[7633]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mec_sp_s[8065]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mec_sp_s[8209]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[8353]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[290]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[434]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[7058]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[7202]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[7634]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mec_sp_s[7922]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[8066]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mec_sp_s[8210]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[8354]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[3]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[291]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[435]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mec_sp_s[579]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[723]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[1011]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[7635]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mec_sp_s[8067]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[8211]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mec_sp_s[8355]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mec_sp_s[4]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mec_sp_s[148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mec_sp_s[292]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mec_sp_s[436]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mec_sp_s[580]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mec_sp_s[724]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mec_sp_s[868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mec_sp_s[1012]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mec_sp_s[7780]=-(kkappa*Pssp*yss[9]);
	Mec_sp_s[8068]=pow(E,yss[8])*Pssp;
	Mec_sp_s[8212]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mec_sp_s[8356]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mec_sp_s[5]=iiota*Pssp*zbar;
	Mec_sp_s[437]=iiota*Pssp*zbar;
	Mec_sp_s[7781]=-Pssp;
	Mec_sp_s[7062]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mec_sp_s[7926]=-(pow(E,yss[7])*Pssp);
	Mec_sp_s[8214]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[8358]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[151]=-((Pssp*zbar)/(1 + yss[5]));
	Mec_sp_s[295]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[439]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mec_sp_s[583]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mec_sp_s[871]=-(pow(E,yss[11])*ebar*Pssp);
	Mec_sp_s[6919]=-(pow(E,yss[0])*Pssp);
	Mec_sp_s[7063]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mec_sp_s[7207]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mec_sp_s[7351]=-(pow(E,yss[3])*Pssp);
	Mec_sp_s[7639]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[7927]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mec_sp_s[8215]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[8359]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[8]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[440]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[7352]=pow(E,yss[3])*Pssp;
	Mec_sp_s[8216]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[8360]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[153]=(Pssp*zbar)/(1 + yss[5]);
	Mec_sp_s[441]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mec_sp_s[585]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[7065]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[7209]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[7641]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[7785]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[7929]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[8217]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[8361]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[8218]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[8362]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[155]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mec_sp_s[731]=Pssp;
	Mec_sp_s[7643]=-Pssp;
	Mec_sp_s[8219]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[8363]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[12]=pow(E,xss[0])*Pssp;
	Mec_sp_s[7500]=-(pow(E,xss[0])*Pssp);
	Mec_sp_s[301]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[445]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[589]=pow(E,yss[2])*pbar*Pssp;
	Mec_sp_s[7069]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[7213]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mec_sp_s[8221]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[8365]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[8509]=pow(E,yss[11])*Pssp;
	Mec_sp_s[158]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[446]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[8222]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[8366]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[8510]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mec_sp_s[8654]=Pssp;
	Mec_sp_s[159]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[447]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[8223]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[8367]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[8511]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mec_sp_s[8799]=Pssp;
	Mec_sp_s[880]=ebar*Pssp;
	Mec_sp_s[6928]=pow(E,yss[0] - yss[11])*Pssp;
	Mec_sp_s[7360]=pow(E,yss[3] - yss[11])*Pssp;
	Mec_sp_s[8224]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[8368]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[8512]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mec_sp_s[8944]=Pssp;
	Mec_sp_s[17]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[161]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[305]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[449]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mec_sp_s[593]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[737]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[881]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[1025]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[8225]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[8369]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[9089]=Pssp;
	Mec_sp_s[306]=-Pssp;
	Mec_sp_s[451]=-Pssp;
	Mec_sp_s[596]=-Pssp;
	Mec_sp_s[1029]=-Pssp;
	Mec_sp_s[886]=-Pssp;
	Mec_sp_s[743]=-Pssp;
	Mec_sp_s[2184]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mec_sp_s[9240]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mec_sp_s[9384]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mec_sp_s[10392]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[10536]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[10680]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[1465]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[1609]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[1753]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[9385]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[9529]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[9961]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mec_sp_s[10393]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mec_sp_s[10537]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[10681]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[1466]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[1610]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[9386]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[9530]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[9962]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mec_sp_s[10250]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[10394]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mec_sp_s[10538]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[10682]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[1179]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[1323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[1467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[1611]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mec_sp_s[1755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[1899]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[2043]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[2187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[9963]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mec_sp_s[10395]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[10539]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mec_sp_s[10683]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mec_sp_s[1180]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mec_sp_s[1324]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mec_sp_s[1468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mec_sp_s[1612]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mec_sp_s[1756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mec_sp_s[1900]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mec_sp_s[2044]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mec_sp_s[2188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mec_sp_s[10108]=-(kkappa*Pssp*yss[9]);
	Mec_sp_s[10396]=pow(E,yss[8])*Pssp;
	Mec_sp_s[10540]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mec_sp_s[10684]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mec_sp_s[1181]=iiota*Pssp*zbar;
	Mec_sp_s[1613]=iiota*Pssp*zbar;
	Mec_sp_s[10109]=-Pssp;
	Mec_sp_s[9390]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mec_sp_s[10254]=-(pow(E,yss[7])*Pssp);
	Mec_sp_s[10542]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[10686]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[1327]=-((Pssp*zbar)/(1 + yss[5]));
	Mec_sp_s[1471]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[1615]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mec_sp_s[1759]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mec_sp_s[2047]=-(pow(E,yss[11])*ebar*Pssp);
	Mec_sp_s[9247]=-(pow(E,yss[0])*Pssp);
	Mec_sp_s[9391]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mec_sp_s[9535]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mec_sp_s[9679]=-(pow(E,yss[3])*Pssp);
	Mec_sp_s[9967]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[10255]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mec_sp_s[10543]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[10687]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[1184]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[1616]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[9680]=pow(E,yss[3])*Pssp;
	Mec_sp_s[10544]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[10688]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[1185]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[1329]=(Pssp*zbar)/(1 + yss[5]);
	Mec_sp_s[1617]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mec_sp_s[1761]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[9393]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[9537]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[9969]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[10113]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[10257]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[10545]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[10689]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[10546]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[10690]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[1331]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mec_sp_s[1907]=Pssp;
	Mec_sp_s[9971]=-Pssp;
	Mec_sp_s[10547]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[10691]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[1188]=pow(E,xss[0])*Pssp;
	Mec_sp_s[9828]=-(pow(E,xss[0])*Pssp);
	Mec_sp_s[1477]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[1621]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[1765]=pow(E,yss[2])*pbar*Pssp;
	Mec_sp_s[9397]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[9541]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mec_sp_s[10549]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[10693]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[10837]=pow(E,yss[11])*Pssp;
	Mec_sp_s[1334]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[1622]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[10550]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[10694]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[10838]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mec_sp_s[10982]=Pssp;
	Mec_sp_s[1335]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[1623]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[10551]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[10695]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[10839]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mec_sp_s[11127]=Pssp;
	Mec_sp_s[2056]=ebar*Pssp;
	Mec_sp_s[9256]=pow(E,yss[0] - yss[11])*Pssp;
	Mec_sp_s[9688]=pow(E,yss[3] - yss[11])*Pssp;
	Mec_sp_s[10552]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[10696]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[10840]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mec_sp_s[11272]=Pssp;
	Mec_sp_s[1193]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[1337]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[1481]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[1625]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mec_sp_s[1769]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[1913]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[2057]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[2201]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[10553]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[10697]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[11417]=Pssp;
	Mec_sp_s[1482]=-Pssp;
	Mec_sp_s[1627]=-Pssp;
	Mec_sp_s[1772]=-Pssp;
	Mec_sp_s[2205]=-Pssp;
	Mec_sp_s[2062]=-Pssp;
	Mec_sp_s[1919]=-Pssp;
	Mec_sp_s[3360]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mec_sp_s[11568]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mec_sp_s[11712]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mec_sp_s[12720]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[12864]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[13008]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[2641]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[2785]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[2929]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[11713]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[11857]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[12289]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mec_sp_s[12721]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mec_sp_s[12865]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[13009]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[2642]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[2786]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[11714]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[11858]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[12290]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mec_sp_s[12578]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[12722]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mec_sp_s[12866]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[13010]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[2355]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[2499]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[2643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[2787]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mec_sp_s[2931]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[3075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[3219]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[3363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[12291]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mec_sp_s[12723]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[12867]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mec_sp_s[13011]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mec_sp_s[2356]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mec_sp_s[2500]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mec_sp_s[2644]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mec_sp_s[2788]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mec_sp_s[2932]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mec_sp_s[3076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mec_sp_s[3220]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mec_sp_s[3364]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mec_sp_s[12436]=-(kkappa*Pssp*yss[9]);
	Mec_sp_s[12724]=pow(E,yss[8])*Pssp;
	Mec_sp_s[12868]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mec_sp_s[13012]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mec_sp_s[2357]=iiota*Pssp*zbar;
	Mec_sp_s[2789]=iiota*Pssp*zbar;
	Mec_sp_s[12437]=-Pssp;
	Mec_sp_s[11718]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mec_sp_s[12582]=-(pow(E,yss[7])*Pssp);
	Mec_sp_s[12870]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[13014]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[2503]=-((Pssp*zbar)/(1 + yss[5]));
	Mec_sp_s[2647]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[2791]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mec_sp_s[2935]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mec_sp_s[3223]=-(pow(E,yss[11])*ebar*Pssp);
	Mec_sp_s[11575]=-(pow(E,yss[0])*Pssp);
	Mec_sp_s[11719]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mec_sp_s[11863]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mec_sp_s[12007]=-(pow(E,yss[3])*Pssp);
	Mec_sp_s[12295]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[12583]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mec_sp_s[12871]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[13015]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[2360]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[2792]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[12008]=pow(E,yss[3])*Pssp;
	Mec_sp_s[12872]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[13016]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[2361]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[2505]=(Pssp*zbar)/(1 + yss[5]);
	Mec_sp_s[2793]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mec_sp_s[2937]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[11721]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[11865]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[12297]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[12441]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[12585]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[12873]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[13017]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[12874]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[13018]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[2507]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mec_sp_s[3083]=Pssp;
	Mec_sp_s[12299]=-Pssp;
	Mec_sp_s[12875]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[13019]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[2364]=pow(E,xss[0])*Pssp;
	Mec_sp_s[12156]=-(pow(E,xss[0])*Pssp);
	Mec_sp_s[2653]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[2797]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[2941]=pow(E,yss[2])*pbar*Pssp;
	Mec_sp_s[11725]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[11869]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mec_sp_s[12877]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[13021]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[13165]=pow(E,yss[11])*Pssp;
	Mec_sp_s[2510]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[2798]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[12878]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[13022]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[13166]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mec_sp_s[13310]=Pssp;
	Mec_sp_s[2511]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[2799]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[12879]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[13023]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[13167]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mec_sp_s[13455]=Pssp;
	Mec_sp_s[3232]=ebar*Pssp;
	Mec_sp_s[11584]=pow(E,yss[0] - yss[11])*Pssp;
	Mec_sp_s[12016]=pow(E,yss[3] - yss[11])*Pssp;
	Mec_sp_s[12880]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[13024]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[13168]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mec_sp_s[13600]=Pssp;
	Mec_sp_s[2369]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[2513]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[2657]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[2801]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mec_sp_s[2945]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[3089]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[3233]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[3377]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[12881]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[13025]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[13745]=Pssp;
	Mec_sp_s[2658]=-Pssp;
	Mec_sp_s[2803]=-Pssp;
	Mec_sp_s[2948]=-Pssp;
	Mec_sp_s[3381]=-Pssp;
	Mec_sp_s[3238]=-Pssp;
	Mec_sp_s[3095]=-Pssp;
	Mec_sp_s[4536]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mec_sp_s[13896]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mec_sp_s[14040]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mec_sp_s[15048]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[15192]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[15336]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[3817]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[3961]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[4105]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[14041]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[14185]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[14617]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mec_sp_s[15049]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mec_sp_s[15193]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[15337]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[3818]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[3962]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[14042]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[14186]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[14618]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mec_sp_s[14906]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[15050]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mec_sp_s[15194]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[15338]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[3531]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[3675]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[3819]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[3963]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mec_sp_s[4107]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[4251]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[4395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[4539]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[14619]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mec_sp_s[15051]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[15195]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mec_sp_s[15339]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mec_sp_s[3532]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mec_sp_s[3676]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mec_sp_s[3820]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mec_sp_s[3964]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mec_sp_s[4108]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mec_sp_s[4252]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mec_sp_s[4396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mec_sp_s[4540]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mec_sp_s[14764]=-(kkappa*Pssp*yss[9]);
	Mec_sp_s[15052]=pow(E,yss[8])*Pssp;
	Mec_sp_s[15196]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mec_sp_s[15340]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mec_sp_s[3533]=iiota*Pssp*zbar;
	Mec_sp_s[3965]=iiota*Pssp*zbar;
	Mec_sp_s[14765]=-Pssp;
	Mec_sp_s[14046]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mec_sp_s[14910]=-(pow(E,yss[7])*Pssp);
	Mec_sp_s[15198]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[15342]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[3679]=-((Pssp*zbar)/(1 + yss[5]));
	Mec_sp_s[3823]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[3967]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mec_sp_s[4111]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mec_sp_s[4399]=-(pow(E,yss[11])*ebar*Pssp);
	Mec_sp_s[13903]=-(pow(E,yss[0])*Pssp);
	Mec_sp_s[14047]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mec_sp_s[14191]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mec_sp_s[14335]=-(pow(E,yss[3])*Pssp);
	Mec_sp_s[14623]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[14911]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mec_sp_s[15199]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[15343]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[3536]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[3968]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[14336]=pow(E,yss[3])*Pssp;
	Mec_sp_s[15200]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[15344]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[3537]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[3681]=(Pssp*zbar)/(1 + yss[5]);
	Mec_sp_s[3969]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mec_sp_s[4113]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[14049]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[14193]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[14625]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[14769]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[14913]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[15201]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[15345]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[15202]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[15346]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[3683]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mec_sp_s[4259]=Pssp;
	Mec_sp_s[14627]=-Pssp;
	Mec_sp_s[15203]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[15347]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[3540]=pow(E,xss[0])*Pssp;
	Mec_sp_s[14484]=-(pow(E,xss[0])*Pssp);
	Mec_sp_s[3829]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[3973]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[4117]=pow(E,yss[2])*pbar*Pssp;
	Mec_sp_s[14053]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[14197]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mec_sp_s[15205]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[15349]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[15493]=pow(E,yss[11])*Pssp;
	Mec_sp_s[3686]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[3974]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[15206]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[15350]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[15494]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mec_sp_s[15638]=Pssp;
	Mec_sp_s[3687]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[3975]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[15207]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[15351]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[15495]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mec_sp_s[15783]=Pssp;
	Mec_sp_s[4408]=ebar*Pssp;
	Mec_sp_s[13912]=pow(E,yss[0] - yss[11])*Pssp;
	Mec_sp_s[14344]=pow(E,yss[3] - yss[11])*Pssp;
	Mec_sp_s[15208]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[15352]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[15496]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mec_sp_s[15928]=Pssp;
	Mec_sp_s[3545]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[3689]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[3833]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[3977]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mec_sp_s[4121]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[4265]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[4409]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[4553]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[15209]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[15353]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[16073]=Pssp;
	Mec_sp_s[3834]=-Pssp;
	Mec_sp_s[3979]=-Pssp;
	Mec_sp_s[4124]=-Pssp;
	Mec_sp_s[4557]=-Pssp;
	Mec_sp_s[4414]=-Pssp;
	Mec_sp_s[4271]=-Pssp;
	Mec_sp_s[5712]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mec_sp_s[16224]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mec_sp_s[16368]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mec_sp_s[17376]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[17520]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[17664]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[4993]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[5137]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[5281]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[16369]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[16513]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[16945]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mec_sp_s[17377]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mec_sp_s[17521]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[17665]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[4994]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[5138]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[16370]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[16514]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[16946]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mec_sp_s[17234]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[17378]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mec_sp_s[17522]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[17666]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[4707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[4851]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[4995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[5139]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mec_sp_s[5283]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[5427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[5571]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[5715]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[16947]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mec_sp_s[17379]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[17523]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mec_sp_s[17667]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mec_sp_s[4708]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mec_sp_s[4852]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mec_sp_s[4996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mec_sp_s[5140]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mec_sp_s[5284]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mec_sp_s[5428]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mec_sp_s[5572]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mec_sp_s[5716]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mec_sp_s[17092]=-(kkappa*Pssp*yss[9]);
	Mec_sp_s[17380]=pow(E,yss[8])*Pssp;
	Mec_sp_s[17524]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mec_sp_s[17668]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mec_sp_s[4709]=iiota*Pssp*zbar;
	Mec_sp_s[5141]=iiota*Pssp*zbar;
	Mec_sp_s[17093]=-Pssp;
	Mec_sp_s[16374]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mec_sp_s[17238]=-(pow(E,yss[7])*Pssp);
	Mec_sp_s[17526]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[17670]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[4855]=-((Pssp*zbar)/(1 + yss[5]));
	Mec_sp_s[4999]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[5143]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mec_sp_s[5287]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mec_sp_s[5575]=-(pow(E,yss[11])*ebar*Pssp);
	Mec_sp_s[16231]=-(pow(E,yss[0])*Pssp);
	Mec_sp_s[16375]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mec_sp_s[16519]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mec_sp_s[16663]=-(pow(E,yss[3])*Pssp);
	Mec_sp_s[16951]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[17239]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mec_sp_s[17527]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[17671]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[4712]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[5144]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[16664]=pow(E,yss[3])*Pssp;
	Mec_sp_s[17528]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[17672]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[4713]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[4857]=(Pssp*zbar)/(1 + yss[5]);
	Mec_sp_s[5145]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mec_sp_s[5289]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[16377]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[16521]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[16953]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[17097]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[17241]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[17529]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[17673]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[17530]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[17674]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[4859]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mec_sp_s[5435]=Pssp;
	Mec_sp_s[16955]=-Pssp;
	Mec_sp_s[17531]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[17675]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[4716]=pow(E,xss[0])*Pssp;
	Mec_sp_s[16812]=-(pow(E,xss[0])*Pssp);
	Mec_sp_s[5005]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[5149]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[5293]=pow(E,yss[2])*pbar*Pssp;
	Mec_sp_s[16381]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[16525]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mec_sp_s[17533]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[17677]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[17821]=pow(E,yss[11])*Pssp;
	Mec_sp_s[4862]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[5150]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[17534]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[17678]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[17822]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mec_sp_s[17966]=Pssp;
	Mec_sp_s[4863]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[5151]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[17535]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[17679]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[17823]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mec_sp_s[18111]=Pssp;
	Mec_sp_s[5584]=ebar*Pssp;
	Mec_sp_s[16240]=pow(E,yss[0] - yss[11])*Pssp;
	Mec_sp_s[16672]=pow(E,yss[3] - yss[11])*Pssp;
	Mec_sp_s[17536]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[17680]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[17824]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mec_sp_s[18256]=Pssp;
	Mec_sp_s[4721]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[4865]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[5009]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[5153]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mec_sp_s[5297]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[5441]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[5585]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[5729]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[17537]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[17681]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[18401]=Pssp;
	Mec_sp_s[5010]=-Pssp;
	Mec_sp_s[5155]=-Pssp;
	Mec_sp_s[5300]=-Pssp;
	Mec_sp_s[5733]=-Pssp;
	Mec_sp_s[5590]=-Pssp;
	Mec_sp_s[5447]=-Pssp;
	Mec_sp_s[6888]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mec_sp_s[18552]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mec_sp_s[18696]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mec_sp_s[19704]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[19848]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[19992]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mec_sp_s[6169]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[6313]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[6457]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[18697]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[18841]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[19273]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mec_sp_s[19705]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mec_sp_s[19849]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[19993]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[6170]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[6314]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[18698]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[18842]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[19274]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mec_sp_s[19562]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[19706]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mec_sp_s[19850]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[19994]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mec_sp_s[5883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[6027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[6171]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[6315]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mec_sp_s[6459]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[6603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[6747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[6891]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mec_sp_s[19275]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mec_sp_s[19707]=-(pow(E,yss[8])*Pssp);
	Mec_sp_s[19851]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mec_sp_s[19995]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mec_sp_s[5884]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mec_sp_s[6028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mec_sp_s[6172]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mec_sp_s[6316]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mec_sp_s[6460]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mec_sp_s[6604]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mec_sp_s[6748]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mec_sp_s[6892]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mec_sp_s[19420]=-(kkappa*Pssp*yss[9]);
	Mec_sp_s[19708]=pow(E,yss[8])*Pssp;
	Mec_sp_s[19852]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mec_sp_s[19996]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mec_sp_s[5885]=iiota*Pssp*zbar;
	Mec_sp_s[6317]=iiota*Pssp*zbar;
	Mec_sp_s[19421]=-Pssp;
	Mec_sp_s[18702]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mec_sp_s[19566]=-(pow(E,yss[7])*Pssp);
	Mec_sp_s[19854]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[19998]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mec_sp_s[6031]=-((Pssp*zbar)/(1 + yss[5]));
	Mec_sp_s[6175]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mec_sp_s[6319]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mec_sp_s[6463]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mec_sp_s[6751]=-(pow(E,yss[11])*ebar*Pssp);
	Mec_sp_s[18559]=-(pow(E,yss[0])*Pssp);
	Mec_sp_s[18703]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mec_sp_s[18847]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mec_sp_s[18991]=-(pow(E,yss[3])*Pssp);
	Mec_sp_s[19279]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[19567]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mec_sp_s[19855]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[19999]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mec_sp_s[5888]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[6320]=-(pow(E,xss[0])*Pssp*zbar);
	Mec_sp_s[18992]=pow(E,yss[3])*Pssp;
	Mec_sp_s[19856]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[20000]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mec_sp_s[5889]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[6033]=(Pssp*zbar)/(1 + yss[5]);
	Mec_sp_s[6321]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mec_sp_s[6465]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[18705]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[18849]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[19281]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mec_sp_s[19425]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mec_sp_s[19569]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mec_sp_s[19857]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[20001]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mec_sp_s[19858]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[20002]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mec_sp_s[6035]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mec_sp_s[6611]=Pssp;
	Mec_sp_s[19283]=-Pssp;
	Mec_sp_s[19859]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[20003]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mec_sp_s[5892]=pow(E,xss[0])*Pssp;
	Mec_sp_s[19140]=-(pow(E,xss[0])*Pssp);
	Mec_sp_s[6181]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[6325]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[6469]=pow(E,yss[2])*pbar*Pssp;
	Mec_sp_s[18709]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mec_sp_s[18853]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mec_sp_s[19861]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[20005]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mec_sp_s[20149]=pow(E,yss[11])*Pssp;
	Mec_sp_s[6038]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[6326]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[19862]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[20006]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mec_sp_s[20150]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mec_sp_s[20294]=Pssp;
	Mec_sp_s[6039]=-((Pssp*zbar)/pow(E,yss[11]));
	Mec_sp_s[6327]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mec_sp_s[19863]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[20007]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mec_sp_s[20151]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mec_sp_s[20439]=Pssp;
	Mec_sp_s[6760]=ebar*Pssp;
	Mec_sp_s[18568]=pow(E,yss[0] - yss[11])*Pssp;
	Mec_sp_s[19000]=pow(E,yss[3] - yss[11])*Pssp;
	Mec_sp_s[19864]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[20008]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mec_sp_s[20152]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mec_sp_s[20584]=Pssp;
	Mec_sp_s[5897]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[6041]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[6185]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[6329]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mec_sp_s[6473]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[6617]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[6761]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[6905]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mec_sp_s[19865]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[20009]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mec_sp_s[20729]=Pssp;
	Mec_sp_s[6186]=-Pssp;
	Mec_sp_s[6331]=-Pssp;
	Mec_sp_s[6476]=-Pssp;
	Mec_sp_s[6909]=-Pssp;
	Mec_sp_s[6766]=-Pssp;
	Mec_sp_s[6623]=-Pssp;
	Nec_sp_s[0]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[128]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[129]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[136]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[71] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[119] + (Pssp*Hs[71]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nec_sp_s[1]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[226] - (pbar*pphi*Pssp*Gs[137]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[133]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[67] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[115] + (pbar*pphi*Pssp*Gs[137]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[136]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[133]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[136]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[68]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[68]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nec_sp_s[2]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[66] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[67] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[137]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[133]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[136]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[135]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9]))) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nec_sp_s[3]=-(pow(E,yss[8])*Pssp*Gs[136]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[67]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[64]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[65]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[66]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[67]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[68]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[69]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[70]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[71]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[67]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nec_sp_s[4]=-(kkappa*Pssp*Gs[137]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[136]*Gs[232] - kkappa*Pssp*Gs[134]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[64]*Hs[114] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[66]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[64]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[66]*Hs[115] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[67]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[225] + G2sp[1]*Hs[112] + G2sp[17]*Hs[113] + G2sp[33]*Hs[114] + G2sp[49]*Hs[115] + G2sp[65]*Hs[116] + G2sp[81]*Hs[117] + G2sp[97]*Hs[118] + G2sp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(G2sp[226] + G2sp[2]*Hs[112] + G2sp[18]*Hs[113] + G2sp[34]*Hs[114] + G2sp[50]*Hs[115] + G2sp[66]*Hs[116] + G2sp[82]*Hs[117] + G2sp[98]*Hs[118] + G2sp[114]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(G2sp[228] + G2sp[4]*Hs[112] + G2sp[20]*Hs[113] + G2sp[36]*Hs[114] + G2sp[52]*Hs[115] + G2sp[68]*Hs[116] + G2sp[84]*Hs[117] + G2sp[100]*Hs[118] + G2sp[116]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[64]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[465] + G2sp[17]*Hs[112] + G2sp[257]*Hs[113] + G2sp[273]*Hs[114] + G2sp[289]*Hs[115] + G2sp[305]*Hs[116] + G2sp[321]*Hs[117] + G2sp[337]*Hs[118] + G2sp[353]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[65]*(G2sp[466] + G2sp[18]*Hs[112] + G2sp[258]*Hs[113] + G2sp[274]*Hs[114] + G2sp[290]*Hs[115] + G2sp[306]*Hs[116] + G2sp[322]*Hs[117] + G2sp[338]*Hs[118] + G2sp[354]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[65]*(G2sp[468] + G2sp[20]*Hs[112] + G2sp[260]*Hs[113] + G2sp[276]*Hs[114] + G2sp[292]*Hs[115] + G2sp[308]*Hs[116] + G2sp[324]*Hs[117] + G2sp[340]*Hs[118] + G2sp[356]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[65]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[705] + G2sp[33]*Hs[112] + G2sp[273]*Hs[113] + G2sp[513]*Hs[114] + G2sp[529]*Hs[115] + G2sp[545]*Hs[116] + G2sp[561]*Hs[117] + G2sp[577]*Hs[118] + G2sp[593]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[66]*(G2sp[706] + G2sp[34]*Hs[112] + G2sp[274]*Hs[113] + G2sp[514]*Hs[114] + G2sp[530]*Hs[115] + G2sp[546]*Hs[116] + G2sp[562]*Hs[117] + G2sp[578]*Hs[118] + G2sp[594]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[66]*(G2sp[708] + G2sp[36]*Hs[112] + G2sp[276]*Hs[113] + G2sp[516]*Hs[114] + G2sp[532]*Hs[115] + G2sp[548]*Hs[116] + G2sp[564]*Hs[117] + G2sp[580]*Hs[118] + G2sp[596]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[66]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[945] + G2sp[49]*Hs[112] + G2sp[289]*Hs[113] + G2sp[529]*Hs[114] + G2sp[769]*Hs[115] + G2sp[785]*Hs[116] + G2sp[801]*Hs[117] + G2sp[817]*Hs[118] + G2sp[833]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[67]*(G2sp[946] + G2sp[50]*Hs[112] + G2sp[290]*Hs[113] + G2sp[530]*Hs[114] + G2sp[770]*Hs[115] + G2sp[786]*Hs[116] + G2sp[802]*Hs[117] + G2sp[818]*Hs[118] + G2sp[834]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[67]*(G2sp[948] + G2sp[52]*Hs[112] + G2sp[292]*Hs[113] + G2sp[532]*Hs[114] + G2sp[772]*Hs[115] + G2sp[788]*Hs[116] + G2sp[804]*Hs[117] + G2sp[820]*Hs[118] + G2sp[836]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[1185] + G2sp[65]*Hs[112] + G2sp[305]*Hs[113] + G2sp[545]*Hs[114] + G2sp[785]*Hs[115] + G2sp[1025]*Hs[116] + G2sp[1041]*Hs[117] + G2sp[1057]*Hs[118] + G2sp[1073]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[68]*(G2sp[1186] + G2sp[66]*Hs[112] + G2sp[306]*Hs[113] + G2sp[546]*Hs[114] + G2sp[786]*Hs[115] + G2sp[1026]*Hs[116] + G2sp[1042]*Hs[117] + G2sp[1058]*Hs[118] + G2sp[1074]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[68]*(G2sp[1188] + G2sp[68]*Hs[112] + G2sp[308]*Hs[113] + G2sp[548]*Hs[114] + G2sp[788]*Hs[115] + G2sp[1028]*Hs[116] + G2sp[1044]*Hs[117] + G2sp[1060]*Hs[118] + G2sp[1076]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[68]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[1425] + G2sp[81]*Hs[112] + G2sp[321]*Hs[113] + G2sp[561]*Hs[114] + G2sp[801]*Hs[115] + G2sp[1041]*Hs[116] + G2sp[1281]*Hs[117] + G2sp[1297]*Hs[118] + G2sp[1313]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[69]*(G2sp[1426] + G2sp[82]*Hs[112] + G2sp[322]*Hs[113] + G2sp[562]*Hs[114] + G2sp[802]*Hs[115] + G2sp[1042]*Hs[116] + G2sp[1282]*Hs[117] + G2sp[1298]*Hs[118] + G2sp[1314]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[69]*(G2sp[1428] + G2sp[84]*Hs[112] + G2sp[324]*Hs[113] + G2sp[564]*Hs[114] + G2sp[804]*Hs[115] + G2sp[1044]*Hs[116] + G2sp[1284]*Hs[117] + G2sp[1300]*Hs[118] + G2sp[1316]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[69]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[1665] + G2sp[97]*Hs[112] + G2sp[337]*Hs[113] + G2sp[577]*Hs[114] + G2sp[817]*Hs[115] + G2sp[1057]*Hs[116] + G2sp[1297]*Hs[117] + G2sp[1537]*Hs[118] + G2sp[1553]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[70]*(G2sp[1666] + G2sp[98]*Hs[112] + G2sp[338]*Hs[113] + G2sp[578]*Hs[114] + G2sp[818]*Hs[115] + G2sp[1058]*Hs[116] + G2sp[1298]*Hs[117] + G2sp[1538]*Hs[118] + G2sp[1554]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[70]*(G2sp[1668] + G2sp[100]*Hs[112] + G2sp[340]*Hs[113] + G2sp[580]*Hs[114] + G2sp[820]*Hs[115] + G2sp[1060]*Hs[116] + G2sp[1300]*Hs[117] + G2sp[1540]*Hs[118] + G2sp[1556]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[70]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[1905] + G2sp[113]*Hs[112] + G2sp[353]*Hs[113] + G2sp[593]*Hs[114] + G2sp[833]*Hs[115] + G2sp[1073]*Hs[116] + G2sp[1313]*Hs[117] + G2sp[1553]*Hs[118] + G2sp[1793]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[71]*(G2sp[1906] + G2sp[114]*Hs[112] + G2sp[354]*Hs[113] + G2sp[594]*Hs[114] + G2sp[834]*Hs[115] + G2sp[1074]*Hs[116] + G2sp[1314]*Hs[117] + G2sp[1554]*Hs[118] + G2sp[1794]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[71]*(G2sp[1908] + G2sp[116]*Hs[112] + G2sp[356]*Hs[113] + G2sp[596]*Hs[114] + G2sp[836]*Hs[115] + G2sp[1076]*Hs[116] + G2sp[1316]*Hs[117] + G2sp[1556]*Hs[118] + G2sp[1796]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[71]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[64]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[66]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[67]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[64]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[67]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[134]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nec_sp_s[5]=-(Pssp*Gs[134]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67])) + iiota*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[6]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[129]*Gs[225] - pow(E,yss[7])*Pssp*Gs[135]*Gs[231] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129] - pow(E,yss[7])*Gs[135])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nec_sp_s[7]=-(pow(E,yss[0])*Pssp*Gs[128]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[226] - pow(E,yss[3])*Pssp*Gs[131]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[67] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[67] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[70]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[133]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[65])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[67]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[133]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[67]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[65]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[67]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[128]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - pow(E,yss[3])*Gs[131] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[2])*pbar*(Gs[130] + Hs[68]) - pow(E,yss[11])*ebar*Hs[70] - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*yss[5] + (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[65])/(1 + yss[5]) - (zbar*Hs[67]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nec_sp_s[8]=pow(E,yss[3])*Pssp*Gs[131]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[131] - pow(E,xss[0])*zbar*(Hs[64] + Hs[67])) - pow(E,xss[0])*Pssp*zbar*(Hs[64] + Hs[67])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[64] + Hs[67])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[9]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[134] + Hs[64] + Hs[67])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[133]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[133]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[65])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[67]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[133]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[67]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[65]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[67]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[129] + Gs[135])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[130] + Hs[68])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[133]) - Gs[138] + pow(E,xss[0])*kkappa*zbar*(Gs[134] + Hs[64] + Hs[67]) - (zbar*Gs[133]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[65])/(1 + yss[5]) + (zbar*Hs[67]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[129] + Gs[135]) + pow(E,yss[2])*pbar*(Gs[130] + Hs[68]))*(1 + yss[5])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nec_sp_s[10]=((-1 + nnus)*Gs[137] + nnus*Gs[138])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nec_sp_s[11]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[133] - pow(E,bbar - xss[1])*ppsir*Hs[65] + Hs[69]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[65]*Hs[113] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nec_sp_s[12]=pow(E,xss[0])*(-(Pssp*Gs[132]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[132] - Hs[64]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(Gs[228] - Hs[112]) + Pssp*Hs[64]*Hs[112]);
	Nec_sp_s[13]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[130]*Gs[226] + pow(E,yss[11])*Pssp*Gs[139]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[66] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[67] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[130] + pow(E,yss[11])*Gs[139] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] + pow(E,yss[2])*pbar*(Gs[130] + Hs[68])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[66]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[67]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[130] + Hs[68])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nec_sp_s[14]=(Pssp*zbar*(Gs[139] - Hs[67])*Hs[113] + Pssp*zbar*Hs[65]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[139] - Hs[67])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[140] - zbar*Hs[65] + zbar*(Gs[139] - Hs[67])*xss[1]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[15]=(-(Pssp*zbar*Hs[67]*Hs[113]) - Pssp*zbar*Hs[65]*Hs[115] - Pssp*(-1 + zbar)*Gs[139]*Gs[235]*xss[1] - Pssp*zbar*Hs[67]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[65] + Hs[67]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[141]) + zbar*Hs[65] - (-1 + zbar)*Gs[139]*xss[1] + zbar*Hs[67]*xss[1]) + Pssp*zbar*Gs[139]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[16]=pow(E,yss[0] - yss[11])*Pssp*Gs[128]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[131]*Gs[227] - Pssp*Gs[139]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[139]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[11])*Gs[139] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[128] + pow(E,yss[3])*Gs[131] - pow(E,yss[0])*Gs[139] - pow(E,yss[3])*Gs[139] - pow(E,yss[11])*ebar*Gs[139] + pow(E,yss[11])*Gs[142] + pow(E,yss[11])*ebar*Hs[70]))/pow(E,yss[11]) + ebar*Pssp*Hs[70]*Hs[118] - (Pssp*Gs[139]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nec_sp_s[17]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[67]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[137]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[137]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[67]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*Hs[64]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[65]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[66]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[67]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[68]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[69]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[70]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[71]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[67]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[143] + pow(zbar,rrho)*(-Gs[137] + (-(rrho*rrhoz) + Gsp[56])*Hs[67]*yss[9] + (Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*yss[9])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nec_sp_s[18]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(ssigmaa - Hs[66]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[114];
	Nec_sp_s[19]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[67]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[115];
	Nec_sp_s[20]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[68]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[116];
	Nec_sp_s[21]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[71]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[119];
	Nec_sp_s[22]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[70]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[118];
	Nec_sp_s[23]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[69]) - (dP2ssp*Gs[137] + dP1ssp*Gs[138])*Hs[117];
	Nec_sp_s[24]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[144]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[145]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[152]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[79] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])) - pow(E,yss[8])*Gs[152] + Hs[79]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[144] - pow(pow(E,yss[1]),oomega)*Gs[145])*Hs[119] + (Pssp*Hs[79]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nec_sp_s[25]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[226] - (pbar*pphi*Pssp*Gs[153]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[149]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[74] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[75] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[115] + (pbar*pphi*Pssp*Gs[153]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[152]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[149]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[152]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[76]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[76]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[75] - pbar*Hs[76]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nec_sp_s[26]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[145]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[74] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[75] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[75] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[153]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[149]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[152]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[151]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[151]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[146] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[7])*pphi*Gs[151]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[149]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[153] - Gs[152]*yss[9]))) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nec_sp_s[27]=-(pow(E,yss[8])*Pssp*Gs[152]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[75])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[149]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[149]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[75]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[72]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[73]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[74]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[75]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[76]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[77]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[78]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[79]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[75]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[149])/pow(zbar,rrho) - pow(E,yss[8])*Gs[152] + Gs[153] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[75]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nec_sp_s[28]=-(kkappa*Pssp*Gs[153]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[152]*Gs[232] - kkappa*Pssp*Gs[150]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[72]*Hs[114] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[74]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[72]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[74]*Hs[115] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[75]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[152]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[225] + G2sp[1]*Hs[112] + G2sp[17]*Hs[113] + G2sp[33]*Hs[114] + G2sp[49]*Hs[115] + G2sp[65]*Hs[116] + G2sp[81]*Hs[117] + G2sp[97]*Hs[118] + G2sp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(G2sp[226] + G2sp[2]*Hs[112] + G2sp[18]*Hs[113] + G2sp[34]*Hs[114] + G2sp[50]*Hs[115] + G2sp[66]*Hs[116] + G2sp[82]*Hs[117] + G2sp[98]*Hs[118] + G2sp[114]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*(G2sp[228] + G2sp[4]*Hs[112] + G2sp[20]*Hs[113] + G2sp[36]*Hs[114] + G2sp[52]*Hs[115] + G2sp[68]*Hs[116] + G2sp[84]*Hs[117] + G2sp[100]*Hs[118] + G2sp[116]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[72]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[465] + G2sp[17]*Hs[112] + G2sp[257]*Hs[113] + G2sp[273]*Hs[114] + G2sp[289]*Hs[115] + G2sp[305]*Hs[116] + G2sp[321]*Hs[117] + G2sp[337]*Hs[118] + G2sp[353]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[73]*(G2sp[466] + G2sp[18]*Hs[112] + G2sp[258]*Hs[113] + G2sp[274]*Hs[114] + G2sp[290]*Hs[115] + G2sp[306]*Hs[116] + G2sp[322]*Hs[117] + G2sp[338]*Hs[118] + G2sp[354]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[73]*(G2sp[468] + G2sp[20]*Hs[112] + G2sp[260]*Hs[113] + G2sp[276]*Hs[114] + G2sp[292]*Hs[115] + G2sp[308]*Hs[116] + G2sp[324]*Hs[117] + G2sp[340]*Hs[118] + G2sp[356]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[73]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[705] + G2sp[33]*Hs[112] + G2sp[273]*Hs[113] + G2sp[513]*Hs[114] + G2sp[529]*Hs[115] + G2sp[545]*Hs[116] + G2sp[561]*Hs[117] + G2sp[577]*Hs[118] + G2sp[593]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[74]*(G2sp[706] + G2sp[34]*Hs[112] + G2sp[274]*Hs[113] + G2sp[514]*Hs[114] + G2sp[530]*Hs[115] + G2sp[546]*Hs[116] + G2sp[562]*Hs[117] + G2sp[578]*Hs[118] + G2sp[594]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[74]*(G2sp[708] + G2sp[36]*Hs[112] + G2sp[276]*Hs[113] + G2sp[516]*Hs[114] + G2sp[532]*Hs[115] + G2sp[548]*Hs[116] + G2sp[564]*Hs[117] + G2sp[580]*Hs[118] + G2sp[596]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[74]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[945] + G2sp[49]*Hs[112] + G2sp[289]*Hs[113] + G2sp[529]*Hs[114] + G2sp[769]*Hs[115] + G2sp[785]*Hs[116] + G2sp[801]*Hs[117] + G2sp[817]*Hs[118] + G2sp[833]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[75]*(G2sp[946] + G2sp[50]*Hs[112] + G2sp[290]*Hs[113] + G2sp[530]*Hs[114] + G2sp[770]*Hs[115] + G2sp[786]*Hs[116] + G2sp[802]*Hs[117] + G2sp[818]*Hs[118] + G2sp[834]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[75]*(G2sp[948] + G2sp[52]*Hs[112] + G2sp[292]*Hs[113] + G2sp[532]*Hs[114] + G2sp[772]*Hs[115] + G2sp[788]*Hs[116] + G2sp[804]*Hs[117] + G2sp[820]*Hs[118] + G2sp[836]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[1185] + G2sp[65]*Hs[112] + G2sp[305]*Hs[113] + G2sp[545]*Hs[114] + G2sp[785]*Hs[115] + G2sp[1025]*Hs[116] + G2sp[1041]*Hs[117] + G2sp[1057]*Hs[118] + G2sp[1073]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[76]*(G2sp[1186] + G2sp[66]*Hs[112] + G2sp[306]*Hs[113] + G2sp[546]*Hs[114] + G2sp[786]*Hs[115] + G2sp[1026]*Hs[116] + G2sp[1042]*Hs[117] + G2sp[1058]*Hs[118] + G2sp[1074]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[76]*(G2sp[1188] + G2sp[68]*Hs[112] + G2sp[308]*Hs[113] + G2sp[548]*Hs[114] + G2sp[788]*Hs[115] + G2sp[1028]*Hs[116] + G2sp[1044]*Hs[117] + G2sp[1060]*Hs[118] + G2sp[1076]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[76]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[1425] + G2sp[81]*Hs[112] + G2sp[321]*Hs[113] + G2sp[561]*Hs[114] + G2sp[801]*Hs[115] + G2sp[1041]*Hs[116] + G2sp[1281]*Hs[117] + G2sp[1297]*Hs[118] + G2sp[1313]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[77]*(G2sp[1426] + G2sp[82]*Hs[112] + G2sp[322]*Hs[113] + G2sp[562]*Hs[114] + G2sp[802]*Hs[115] + G2sp[1042]*Hs[116] + G2sp[1282]*Hs[117] + G2sp[1298]*Hs[118] + G2sp[1314]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[77]*(G2sp[1428] + G2sp[84]*Hs[112] + G2sp[324]*Hs[113] + G2sp[564]*Hs[114] + G2sp[804]*Hs[115] + G2sp[1044]*Hs[116] + G2sp[1284]*Hs[117] + G2sp[1300]*Hs[118] + G2sp[1316]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[77]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[1665] + G2sp[97]*Hs[112] + G2sp[337]*Hs[113] + G2sp[577]*Hs[114] + G2sp[817]*Hs[115] + G2sp[1057]*Hs[116] + G2sp[1297]*Hs[117] + G2sp[1537]*Hs[118] + G2sp[1553]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[78]*(G2sp[1666] + G2sp[98]*Hs[112] + G2sp[338]*Hs[113] + G2sp[578]*Hs[114] + G2sp[818]*Hs[115] + G2sp[1058]*Hs[116] + G2sp[1298]*Hs[117] + G2sp[1538]*Hs[118] + G2sp[1554]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[78]*(G2sp[1668] + G2sp[100]*Hs[112] + G2sp[340]*Hs[113] + G2sp[580]*Hs[114] + G2sp[820]*Hs[115] + G2sp[1060]*Hs[116] + G2sp[1300]*Hs[117] + G2sp[1540]*Hs[118] + G2sp[1556]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[78]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[1905] + G2sp[113]*Hs[112] + G2sp[353]*Hs[113] + G2sp[593]*Hs[114] + G2sp[833]*Hs[115] + G2sp[1073]*Hs[116] + G2sp[1313]*Hs[117] + G2sp[1553]*Hs[118] + G2sp[1793]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[79]*(G2sp[1906] + G2sp[114]*Hs[112] + G2sp[354]*Hs[113] + G2sp[594]*Hs[114] + G2sp[834]*Hs[115] + G2sp[1074]*Hs[116] + G2sp[1314]*Hs[117] + G2sp[1554]*Hs[118] + G2sp[1794]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[79]*(G2sp[1908] + G2sp[116]*Hs[112] + G2sp[356]*Hs[113] + G2sp[596]*Hs[114] + G2sp[836]*Hs[115] + G2sp[1076]*Hs[116] + G2sp[1316]*Hs[117] + G2sp[1556]*Hs[118] + G2sp[1796]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[79]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[72]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[74]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[75]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[72]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[75]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[150]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[152] - kkappa*Gs[153] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[75])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[72] + Hs[75]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[72] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[72] + Gsp[17]*Hs[73] + Gsp[33]*Hs[74] + Gsp[49]*Hs[75] + Gsp[65]*Hs[76] + Gsp[81]*Hs[77] + Gsp[97]*Hs[78] + Gsp[113]*Hs[79]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[72] + Gsp[18]*Hs[73] + Gsp[34]*Hs[74] + Gsp[50]*Hs[75] + Gsp[66]*Hs[76] + Gsp[82]*Hs[77] + Gsp[98]*Hs[78] + Gsp[114]*Hs[79]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[72] + Gsp[20]*Hs[73] + Gsp[36]*Hs[74] + (rrhoz + Gsp[52])*Hs[75] + Gsp[68]*Hs[76] + Gsp[84]*Hs[77] + Gsp[100]*Hs[78] + Gsp[116]*Hs[79])))/pow(zbar,rrho) - kkappa*Gs[150]*yss[9]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nec_sp_s[29]=-(Pssp*Gs[150]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[150] + iiota*zbar*(Hs[72] + Hs[75])) + iiota*Pssp*zbar*(Hs[72] + Hs[75])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[30]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[145]*Gs[225] - pow(E,yss[7])*Pssp*Gs[151]*Gs[231] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[145] - pow(E,yss[7])*Gs[151])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nec_sp_s[31]=-(pow(E,yss[0])*Pssp*Gs[144]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[226] - pow(E,yss[3])*Pssp*Gs[147]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[74] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[74] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[75] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[75] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[146] + Hs[76])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[78]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[145] + Gs[151])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[146] + Hs[76])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[149]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[73])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[149]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[75]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[149]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[75]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[73]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[75]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[144]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] - pow(E,yss[3])*Gs[147] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] - pow(E,yss[2])*pbar*(Gs[146] + Hs[76]) - pow(E,yss[11])*ebar*Hs[78] - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*yss[5] + (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[73])/(1 + yss[5]) - (zbar*Hs[75]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nec_sp_s[32]=pow(E,yss[3])*Pssp*Gs[147]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[147] - pow(E,xss[0])*zbar*(Hs[72] + Hs[75])) - pow(E,xss[0])*Pssp*zbar*(Hs[72] + Hs[75])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[72] + Hs[75])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[33]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[150] + Hs[72] + Hs[75])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[149]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[149]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[73])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[149]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[75]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[149]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[75]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[73]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[75]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[145] + Gs[151])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[146] + Hs[76])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[149]) - Gs[154] + pow(E,xss[0])*kkappa*zbar*(Gs[150] + Hs[72] + Hs[75]) - (zbar*Gs[149]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[73])/(1 + yss[5]) + (zbar*Hs[75]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[145] + Gs[151]) + pow(E,yss[2])*pbar*(Gs[146] + Hs[76]))*(1 + yss[5])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nec_sp_s[34]=((-1 + nnus)*Gs[153] + nnus*Gs[154])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nec_sp_s[35]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[149] - pow(E,bbar - xss[1])*ppsir*Hs[73] + Hs[77]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[73]*Hs[113] + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nec_sp_s[36]=pow(E,xss[0])*(-(Pssp*Gs[148]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[148] - Hs[72]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(Gs[228] - Hs[112]) + Pssp*Hs[72]*Hs[112]);
	Nec_sp_s[37]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[146]*Gs[226] + pow(E,yss[11])*Pssp*Gs[155]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[74] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[74] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[75] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[75] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[145]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[146] + pow(E,yss[11])*Gs[155] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[74] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[75] + pow(E,yss[2])*pbar*(Gs[146] + Hs[76])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[145]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[146]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[74]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[75]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[146] + Hs[76])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nec_sp_s[38]=(Pssp*zbar*(Gs[155] - Hs[75])*Hs[113] + Pssp*zbar*Hs[73]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[155] - Hs[75])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[156] - zbar*Hs[73] + zbar*(Gs[155] - Hs[75])*xss[1]) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[39]=(-(Pssp*zbar*Hs[75]*Hs[113]) - Pssp*zbar*Hs[73]*Hs[115] - Pssp*(-1 + zbar)*Gs[155]*Gs[235]*xss[1] - Pssp*zbar*Hs[75]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[73] + Hs[75]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[157]) + zbar*Hs[73] - (-1 + zbar)*Gs[155]*xss[1] + zbar*Hs[75]*xss[1]) + Pssp*zbar*Gs[155]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[40]=pow(E,yss[0] - yss[11])*Pssp*Gs[144]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[147]*Gs[227] - Pssp*Gs[155]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[155]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[11])*Gs[155] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[144] + pow(E,yss[3])*Gs[147] - pow(E,yss[0])*Gs[155] - pow(E,yss[3])*Gs[155] - pow(E,yss[11])*ebar*Gs[155] + pow(E,yss[11])*Gs[158] + pow(E,yss[11])*ebar*Hs[78]))/pow(E,yss[11]) + ebar*Pssp*Hs[78]*Hs[118] - (Pssp*Gs[155]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[153] + dP1ssp*Gs[154])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nec_sp_s[41]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[75]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[153]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[153]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[75]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*Hs[72]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[73]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[74]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[75]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[76]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[77]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[78]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[79]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[75]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[56]*Hs[75] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[159] + pow(zbar,rrho)*(-Gs[153] + (-(rrho*rrhoz) + Gsp[56])*Hs[75]*yss[9] + (Gsp[8]*Hs[72] + Gsp[24]*Hs[73] + Gsp[40]*Hs[74] + Gsp[72]*Hs[76] + Gsp[88]*Hs[77] + Gsp[104]*Hs[78] + Gsp[120]*Hs[79])*yss[9])) + (dP2ssp*Gs[153] + dP1ssp*Gs[154])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nec_sp_s[42]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[74]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[114];
	Nec_sp_s[43]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(ssigmaz - Hs[75]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[115];
	Nec_sp_s[44]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[76]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[116];
	Nec_sp_s[45]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[79]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[119];
	Nec_sp_s[46]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[78]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[118];
	Nec_sp_s[47]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[77]) - (dP2ssp*Gs[153] + dP1ssp*Gs[154])*Hs[117];
	Nec_sp_s[48]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[160]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[161]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[168]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[87] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161])) - pow(E,yss[8])*Gs[168] + Hs[87]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[160] - pow(pow(E,yss[1]),oomega)*Gs[161])*Hs[119] + (Pssp*Hs[87]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nec_sp_s[49]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[226] - (pbar*pphi*Pssp*Gs[169]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[165]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[82] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[82] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[83] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[115] + (pbar*pphi*Pssp*Gs[169]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[168]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[168]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[165]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[168]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[84]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[84]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[161]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[162] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[83] - pbar*Hs[84]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nec_sp_s[50]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[161]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[169]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[165]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[82] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[83] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[83] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[169]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[168]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[168]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[165]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[168]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[167]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[167]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[161]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[162] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] - pow(E,yss[7])*pphi*Gs[167]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[165]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[169] - Gs[168]*yss[9]))) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nec_sp_s[51]=-(pow(E,yss[8])*Pssp*Gs[168]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[83])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[165]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[165]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[83]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[80]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[81]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[82]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[83]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[84]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[85]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[86]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[87]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[83]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[165])/pow(zbar,rrho) - pow(E,yss[8])*Gs[168] + Gs[169] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[83]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nec_sp_s[52]=-(kkappa*Pssp*Gs[169]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[168]*Gs[232] - kkappa*Pssp*Gs[166]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[80]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[80]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[82]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[83]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[80]*Hs[114] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[82]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[83]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[80]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[82]*Hs[115] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[83]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[83]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[168]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[80] + Hs[83])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[80]*(G2sp[225] + G2sp[1]*Hs[112] + G2sp[17]*Hs[113] + G2sp[33]*Hs[114] + G2sp[49]*Hs[115] + G2sp[65]*Hs[116] + G2sp[81]*Hs[117] + G2sp[97]*Hs[118] + G2sp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[80]*(G2sp[226] + G2sp[2]*Hs[112] + G2sp[18]*Hs[113] + G2sp[34]*Hs[114] + G2sp[50]*Hs[115] + G2sp[66]*Hs[116] + G2sp[82]*Hs[117] + G2sp[98]*Hs[118] + G2sp[114]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[80]*(G2sp[228] + G2sp[4]*Hs[112] + G2sp[20]*Hs[113] + G2sp[36]*Hs[114] + G2sp[52]*Hs[115] + G2sp[68]*Hs[116] + G2sp[84]*Hs[117] + G2sp[100]*Hs[118] + G2sp[116]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[80]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[81]*(G2sp[465] + G2sp[17]*Hs[112] + G2sp[257]*Hs[113] + G2sp[273]*Hs[114] + G2sp[289]*Hs[115] + G2sp[305]*Hs[116] + G2sp[321]*Hs[117] + G2sp[337]*Hs[118] + G2sp[353]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[81]*(G2sp[466] + G2sp[18]*Hs[112] + G2sp[258]*Hs[113] + G2sp[274]*Hs[114] + G2sp[290]*Hs[115] + G2sp[306]*Hs[116] + G2sp[322]*Hs[117] + G2sp[338]*Hs[118] + G2sp[354]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[81]*(G2sp[468] + G2sp[20]*Hs[112] + G2sp[260]*Hs[113] + G2sp[276]*Hs[114] + G2sp[292]*Hs[115] + G2sp[308]*Hs[116] + G2sp[324]*Hs[117] + G2sp[340]*Hs[118] + G2sp[356]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[81]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[82]*(G2sp[705] + G2sp[33]*Hs[112] + G2sp[273]*Hs[113] + G2sp[513]*Hs[114] + G2sp[529]*Hs[115] + G2sp[545]*Hs[116] + G2sp[561]*Hs[117] + G2sp[577]*Hs[118] + G2sp[593]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[82]*(G2sp[706] + G2sp[34]*Hs[112] + G2sp[274]*Hs[113] + G2sp[514]*Hs[114] + G2sp[530]*Hs[115] + G2sp[546]*Hs[116] + G2sp[562]*Hs[117] + G2sp[578]*Hs[118] + G2sp[594]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[82]*(G2sp[708] + G2sp[36]*Hs[112] + G2sp[276]*Hs[113] + G2sp[516]*Hs[114] + G2sp[532]*Hs[115] + G2sp[548]*Hs[116] + G2sp[564]*Hs[117] + G2sp[580]*Hs[118] + G2sp[596]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[82]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[83]*(G2sp[945] + G2sp[49]*Hs[112] + G2sp[289]*Hs[113] + G2sp[529]*Hs[114] + G2sp[769]*Hs[115] + G2sp[785]*Hs[116] + G2sp[801]*Hs[117] + G2sp[817]*Hs[118] + G2sp[833]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[83]*(G2sp[946] + G2sp[50]*Hs[112] + G2sp[290]*Hs[113] + G2sp[530]*Hs[114] + G2sp[770]*Hs[115] + G2sp[786]*Hs[116] + G2sp[802]*Hs[117] + G2sp[818]*Hs[118] + G2sp[834]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[83]*(G2sp[948] + G2sp[52]*Hs[112] + G2sp[292]*Hs[113] + G2sp[532]*Hs[114] + G2sp[772]*Hs[115] + G2sp[788]*Hs[116] + G2sp[804]*Hs[117] + G2sp[820]*Hs[118] + G2sp[836]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[83]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[84]*(G2sp[1185] + G2sp[65]*Hs[112] + G2sp[305]*Hs[113] + G2sp[545]*Hs[114] + G2sp[785]*Hs[115] + G2sp[1025]*Hs[116] + G2sp[1041]*Hs[117] + G2sp[1057]*Hs[118] + G2sp[1073]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[84]*(G2sp[1186] + G2sp[66]*Hs[112] + G2sp[306]*Hs[113] + G2sp[546]*Hs[114] + G2sp[786]*Hs[115] + G2sp[1026]*Hs[116] + G2sp[1042]*Hs[117] + G2sp[1058]*Hs[118] + G2sp[1074]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[84]*(G2sp[1188] + G2sp[68]*Hs[112] + G2sp[308]*Hs[113] + G2sp[548]*Hs[114] + G2sp[788]*Hs[115] + G2sp[1028]*Hs[116] + G2sp[1044]*Hs[117] + G2sp[1060]*Hs[118] + G2sp[1076]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[84]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[85]*(G2sp[1425] + G2sp[81]*Hs[112] + G2sp[321]*Hs[113] + G2sp[561]*Hs[114] + G2sp[801]*Hs[115] + G2sp[1041]*Hs[116] + G2sp[1281]*Hs[117] + G2sp[1297]*Hs[118] + G2sp[1313]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[85]*(G2sp[1426] + G2sp[82]*Hs[112] + G2sp[322]*Hs[113] + G2sp[562]*Hs[114] + G2sp[802]*Hs[115] + G2sp[1042]*Hs[116] + G2sp[1282]*Hs[117] + G2sp[1298]*Hs[118] + G2sp[1314]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[85]*(G2sp[1428] + G2sp[84]*Hs[112] + G2sp[324]*Hs[113] + G2sp[564]*Hs[114] + G2sp[804]*Hs[115] + G2sp[1044]*Hs[116] + G2sp[1284]*Hs[117] + G2sp[1300]*Hs[118] + G2sp[1316]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[85]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[86]*(G2sp[1665] + G2sp[97]*Hs[112] + G2sp[337]*Hs[113] + G2sp[577]*Hs[114] + G2sp[817]*Hs[115] + G2sp[1057]*Hs[116] + G2sp[1297]*Hs[117] + G2sp[1537]*Hs[118] + G2sp[1553]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[86]*(G2sp[1666] + G2sp[98]*Hs[112] + G2sp[338]*Hs[113] + G2sp[578]*Hs[114] + G2sp[818]*Hs[115] + G2sp[1058]*Hs[116] + G2sp[1298]*Hs[117] + G2sp[1538]*Hs[118] + G2sp[1554]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[86]*(G2sp[1668] + G2sp[100]*Hs[112] + G2sp[340]*Hs[113] + G2sp[580]*Hs[114] + G2sp[820]*Hs[115] + G2sp[1060]*Hs[116] + G2sp[1300]*Hs[117] + G2sp[1540]*Hs[118] + G2sp[1556]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[86]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[87]*(G2sp[1905] + G2sp[113]*Hs[112] + G2sp[353]*Hs[113] + G2sp[593]*Hs[114] + G2sp[833]*Hs[115] + G2sp[1073]*Hs[116] + G2sp[1313]*Hs[117] + G2sp[1553]*Hs[118] + G2sp[1793]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[87]*(G2sp[1906] + G2sp[114]*Hs[112] + G2sp[354]*Hs[113] + G2sp[594]*Hs[114] + G2sp[834]*Hs[115] + G2sp[1074]*Hs[116] + G2sp[1314]*Hs[117] + G2sp[1554]*Hs[118] + G2sp[1794]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[87]*(G2sp[1908] + G2sp[116]*Hs[112] + G2sp[356]*Hs[113] + G2sp[596]*Hs[114] + G2sp[836]*Hs[115] + G2sp[1076]*Hs[116] + G2sp[1316]*Hs[117] + G2sp[1556]*Hs[118] + G2sp[1796]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[87]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[80]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[82]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[83]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[80]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[82]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[83]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[80]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[83]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[83]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[166]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[168] - kkappa*Gs[169] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[83])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[80] + Hs[83]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[80] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[80] + Gsp[17]*Hs[81] + Gsp[33]*Hs[82] + Gsp[49]*Hs[83] + Gsp[65]*Hs[84] + Gsp[81]*Hs[85] + Gsp[97]*Hs[86] + Gsp[113]*Hs[87]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[80] + Gsp[18]*Hs[81] + Gsp[34]*Hs[82] + Gsp[50]*Hs[83] + Gsp[66]*Hs[84] + Gsp[82]*Hs[85] + Gsp[98]*Hs[86] + Gsp[114]*Hs[87]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[80] + Gsp[20]*Hs[81] + Gsp[36]*Hs[82] + (rrhoz + Gsp[52])*Hs[83] + Gsp[68]*Hs[84] + Gsp[84]*Hs[85] + Gsp[100]*Hs[86] + Gsp[116]*Hs[87])))/pow(zbar,rrho) - kkappa*Gs[166]*yss[9]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nec_sp_s[53]=-(Pssp*Gs[166]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[166] + iiota*zbar*(Hs[80] + Hs[83])) + iiota*Pssp*zbar*(Hs[80] + Hs[83])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[54]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[161]*Gs[225] - pow(E,yss[7])*Pssp*Gs[167]*Gs[231] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[161] - pow(E,yss[7])*Gs[167])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nec_sp_s[55]=-(pow(E,yss[0])*Pssp*Gs[160]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[226] - pow(E,yss[3])*Pssp*Gs[163]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[82] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[83] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[83] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[162] + Hs[84])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[165]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[86]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[161] + Gs[167])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[162] + Hs[84])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[165]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[81])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[165]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[83]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[165]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[83]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[81]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[83]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[160]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[162] - pow(E,yss[3])*Gs[163] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[165] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] - pow(E,yss[2])*pbar*(Gs[162] + Hs[84]) - pow(E,yss[11])*ebar*Hs[86] - pphi*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]))*yss[5] + (zbar*Gs[165]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[81])/(1 + yss[5]) - (zbar*Hs[83]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nec_sp_s[56]=pow(E,yss[3])*Pssp*Gs[163]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[163] - pow(E,xss[0])*zbar*(Hs[80] + Hs[83])) - pow(E,xss[0])*Pssp*zbar*(Hs[80] + Hs[83])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[80] + Hs[83])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[57]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[166] + Hs[80] + Hs[83])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[165]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[165]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[81])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[165]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[83]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[165]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[83]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[81]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[83]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[161] + Gs[167])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[162] + Hs[84])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[165]) - Gs[170] + pow(E,xss[0])*kkappa*zbar*(Gs[166] + Hs[80] + Hs[83]) - (zbar*Gs[165]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[81])/(1 + yss[5]) + (zbar*Hs[83]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[161] + Gs[167]) + pow(E,yss[2])*pbar*(Gs[162] + Hs[84]))*(1 + yss[5])) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nec_sp_s[58]=((-1 + nnus)*Gs[169] + nnus*Gs[170])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nec_sp_s[59]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[165] - pow(E,bbar - xss[1])*ppsir*Hs[81] + Hs[85]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[81]*Hs[113] + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nec_sp_s[60]=pow(E,xss[0])*(-(Pssp*Gs[164]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[164] - Hs[80]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(Gs[228] - Hs[112]) + Pssp*Hs[80]*Hs[112]);
	Nec_sp_s[61]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[162]*Gs[226] + pow(E,yss[11])*Pssp*Gs[171]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[82] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[82] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[83] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[83] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[161]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[162] + pow(E,yss[11])*Gs[171] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[82] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[83] + pow(E,yss[2])*pbar*(Gs[162] + Hs[84])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[161]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[162]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[82]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[83]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[162] + Hs[84])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nec_sp_s[62]=(Pssp*zbar*(Gs[171] - Hs[83])*Hs[113] + Pssp*zbar*Hs[81]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[171] - Hs[83])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[172] - zbar*Hs[81] + zbar*(Gs[171] - Hs[83])*xss[1]) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[63]=(-(Pssp*zbar*Hs[83]*Hs[113]) - Pssp*zbar*Hs[81]*Hs[115] - Pssp*(-1 + zbar)*Gs[171]*Gs[235]*xss[1] - Pssp*zbar*Hs[83]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[81] + Hs[83]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[173]) + zbar*Hs[81] - (-1 + zbar)*Gs[171]*xss[1] + zbar*Hs[83]*xss[1]) + Pssp*zbar*Gs[171]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[64]=pow(E,yss[0] - yss[11])*Pssp*Gs[160]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[163]*Gs[227] - Pssp*Gs[171]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[171]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[160] + pow(E,yss[3])*Gs[163] - pow(E,yss[11])*Gs[171] + pow(E,yss[11])*ebar*Hs[86]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[160] + pow(E,yss[3])*Gs[163] - pow(E,yss[0])*Gs[171] - pow(E,yss[3])*Gs[171] - pow(E,yss[11])*ebar*Gs[171] + pow(E,yss[11])*Gs[174] + pow(E,yss[11])*ebar*Hs[86]))/pow(E,yss[11]) + ebar*Pssp*Hs[86]*Hs[118] - (Pssp*Gs[171]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[169] + dP1ssp*Gs[170])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nec_sp_s[65]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[83]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[169]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[169]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[83]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*Hs[80]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[81]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[82]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[83]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[84]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[85]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[86]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[87]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[83]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[56]*Hs[83] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[175] + pow(zbar,rrho)*(-Gs[169] + (-(rrho*rrhoz) + Gsp[56])*Hs[83]*yss[9] + (Gsp[8]*Hs[80] + Gsp[24]*Hs[81] + Gsp[40]*Hs[82] + Gsp[72]*Hs[84] + Gsp[88]*Hs[85] + Gsp[104]*Hs[86] + Gsp[120]*Hs[87])*yss[9])) + (dP2ssp*Gs[169] + dP1ssp*Gs[170])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nec_sp_s[66]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[82]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[114];
	Nec_sp_s[67]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[83]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[115];
	Nec_sp_s[68]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(ssigmap - Hs[84]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[116];
	Nec_sp_s[69]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[87]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[119];
	Nec_sp_s[70]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[86]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[118];
	Nec_sp_s[71]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[85]) - (dP2ssp*Gs[169] + dP1ssp*Gs[170])*Hs[117];
	Nec_sp_s[72]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[176]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[177]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[184]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[95] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177])) - pow(E,yss[8])*Gs[184] + Hs[95]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[176] - pow(pow(E,yss[1]),oomega)*Gs[177])*Hs[119] + (Pssp*Hs[95]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nec_sp_s[73]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[226] - (pbar*pphi*Pssp*Gs[185]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[181]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[90] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[90] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[91] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[115] + (pbar*pphi*Pssp*Gs[185]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[184]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[184]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[181]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[184]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[92]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[92]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[177]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[178] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[91] - pbar*Hs[92]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nec_sp_s[74]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[177]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[185]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[181]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[90] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[91] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[91] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[185]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[184]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[184]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[181]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[184]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[183]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[183]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[177]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[178] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] - pow(E,yss[7])*pphi*Gs[183]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[181]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[185] - Gs[184]*yss[9]))) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nec_sp_s[75]=-(pow(E,yss[8])*Pssp*Gs[184]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[91])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[181]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[181]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[91]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[88]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[89]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[90]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[91]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[92]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[93]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[94]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[95]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[91]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[181])/pow(zbar,rrho) - pow(E,yss[8])*Gs[184] + Gs[185] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[91]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nec_sp_s[76]=-(kkappa*Pssp*Gs[185]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[184]*Gs[232] - kkappa*Pssp*Gs[182]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[88]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[88]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[90]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[91]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[88]*Hs[114] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[90]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[91]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[88]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[90]*Hs[115] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[91]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[91]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[184]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[88] + Hs[91])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[88]*(G2sp[225] + G2sp[1]*Hs[112] + G2sp[17]*Hs[113] + G2sp[33]*Hs[114] + G2sp[49]*Hs[115] + G2sp[65]*Hs[116] + G2sp[81]*Hs[117] + G2sp[97]*Hs[118] + G2sp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[88]*(G2sp[226] + G2sp[2]*Hs[112] + G2sp[18]*Hs[113] + G2sp[34]*Hs[114] + G2sp[50]*Hs[115] + G2sp[66]*Hs[116] + G2sp[82]*Hs[117] + G2sp[98]*Hs[118] + G2sp[114]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[88]*(G2sp[228] + G2sp[4]*Hs[112] + G2sp[20]*Hs[113] + G2sp[36]*Hs[114] + G2sp[52]*Hs[115] + G2sp[68]*Hs[116] + G2sp[84]*Hs[117] + G2sp[100]*Hs[118] + G2sp[116]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[88]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[89]*(G2sp[465] + G2sp[17]*Hs[112] + G2sp[257]*Hs[113] + G2sp[273]*Hs[114] + G2sp[289]*Hs[115] + G2sp[305]*Hs[116] + G2sp[321]*Hs[117] + G2sp[337]*Hs[118] + G2sp[353]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[89]*(G2sp[466] + G2sp[18]*Hs[112] + G2sp[258]*Hs[113] + G2sp[274]*Hs[114] + G2sp[290]*Hs[115] + G2sp[306]*Hs[116] + G2sp[322]*Hs[117] + G2sp[338]*Hs[118] + G2sp[354]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[89]*(G2sp[468] + G2sp[20]*Hs[112] + G2sp[260]*Hs[113] + G2sp[276]*Hs[114] + G2sp[292]*Hs[115] + G2sp[308]*Hs[116] + G2sp[324]*Hs[117] + G2sp[340]*Hs[118] + G2sp[356]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[89]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[90]*(G2sp[705] + G2sp[33]*Hs[112] + G2sp[273]*Hs[113] + G2sp[513]*Hs[114] + G2sp[529]*Hs[115] + G2sp[545]*Hs[116] + G2sp[561]*Hs[117] + G2sp[577]*Hs[118] + G2sp[593]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[90]*(G2sp[706] + G2sp[34]*Hs[112] + G2sp[274]*Hs[113] + G2sp[514]*Hs[114] + G2sp[530]*Hs[115] + G2sp[546]*Hs[116] + G2sp[562]*Hs[117] + G2sp[578]*Hs[118] + G2sp[594]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[90]*(G2sp[708] + G2sp[36]*Hs[112] + G2sp[276]*Hs[113] + G2sp[516]*Hs[114] + G2sp[532]*Hs[115] + G2sp[548]*Hs[116] + G2sp[564]*Hs[117] + G2sp[580]*Hs[118] + G2sp[596]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[90]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[91]*(G2sp[945] + G2sp[49]*Hs[112] + G2sp[289]*Hs[113] + G2sp[529]*Hs[114] + G2sp[769]*Hs[115] + G2sp[785]*Hs[116] + G2sp[801]*Hs[117] + G2sp[817]*Hs[118] + G2sp[833]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[91]*(G2sp[946] + G2sp[50]*Hs[112] + G2sp[290]*Hs[113] + G2sp[530]*Hs[114] + G2sp[770]*Hs[115] + G2sp[786]*Hs[116] + G2sp[802]*Hs[117] + G2sp[818]*Hs[118] + G2sp[834]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[91]*(G2sp[948] + G2sp[52]*Hs[112] + G2sp[292]*Hs[113] + G2sp[532]*Hs[114] + G2sp[772]*Hs[115] + G2sp[788]*Hs[116] + G2sp[804]*Hs[117] + G2sp[820]*Hs[118] + G2sp[836]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[91]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[92]*(G2sp[1185] + G2sp[65]*Hs[112] + G2sp[305]*Hs[113] + G2sp[545]*Hs[114] + G2sp[785]*Hs[115] + G2sp[1025]*Hs[116] + G2sp[1041]*Hs[117] + G2sp[1057]*Hs[118] + G2sp[1073]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[92]*(G2sp[1186] + G2sp[66]*Hs[112] + G2sp[306]*Hs[113] + G2sp[546]*Hs[114] + G2sp[786]*Hs[115] + G2sp[1026]*Hs[116] + G2sp[1042]*Hs[117] + G2sp[1058]*Hs[118] + G2sp[1074]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[92]*(G2sp[1188] + G2sp[68]*Hs[112] + G2sp[308]*Hs[113] + G2sp[548]*Hs[114] + G2sp[788]*Hs[115] + G2sp[1028]*Hs[116] + G2sp[1044]*Hs[117] + G2sp[1060]*Hs[118] + G2sp[1076]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[92]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[93]*(G2sp[1425] + G2sp[81]*Hs[112] + G2sp[321]*Hs[113] + G2sp[561]*Hs[114] + G2sp[801]*Hs[115] + G2sp[1041]*Hs[116] + G2sp[1281]*Hs[117] + G2sp[1297]*Hs[118] + G2sp[1313]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[93]*(G2sp[1426] + G2sp[82]*Hs[112] + G2sp[322]*Hs[113] + G2sp[562]*Hs[114] + G2sp[802]*Hs[115] + G2sp[1042]*Hs[116] + G2sp[1282]*Hs[117] + G2sp[1298]*Hs[118] + G2sp[1314]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[93]*(G2sp[1428] + G2sp[84]*Hs[112] + G2sp[324]*Hs[113] + G2sp[564]*Hs[114] + G2sp[804]*Hs[115] + G2sp[1044]*Hs[116] + G2sp[1284]*Hs[117] + G2sp[1300]*Hs[118] + G2sp[1316]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[93]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[94]*(G2sp[1665] + G2sp[97]*Hs[112] + G2sp[337]*Hs[113] + G2sp[577]*Hs[114] + G2sp[817]*Hs[115] + G2sp[1057]*Hs[116] + G2sp[1297]*Hs[117] + G2sp[1537]*Hs[118] + G2sp[1553]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[94]*(G2sp[1666] + G2sp[98]*Hs[112] + G2sp[338]*Hs[113] + G2sp[578]*Hs[114] + G2sp[818]*Hs[115] + G2sp[1058]*Hs[116] + G2sp[1298]*Hs[117] + G2sp[1538]*Hs[118] + G2sp[1554]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[94]*(G2sp[1668] + G2sp[100]*Hs[112] + G2sp[340]*Hs[113] + G2sp[580]*Hs[114] + G2sp[820]*Hs[115] + G2sp[1060]*Hs[116] + G2sp[1300]*Hs[117] + G2sp[1540]*Hs[118] + G2sp[1556]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[94]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[95]*(G2sp[1905] + G2sp[113]*Hs[112] + G2sp[353]*Hs[113] + G2sp[593]*Hs[114] + G2sp[833]*Hs[115] + G2sp[1073]*Hs[116] + G2sp[1313]*Hs[117] + G2sp[1553]*Hs[118] + G2sp[1793]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[95]*(G2sp[1906] + G2sp[114]*Hs[112] + G2sp[354]*Hs[113] + G2sp[594]*Hs[114] + G2sp[834]*Hs[115] + G2sp[1074]*Hs[116] + G2sp[1314]*Hs[117] + G2sp[1554]*Hs[118] + G2sp[1794]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[95]*(G2sp[1908] + G2sp[116]*Hs[112] + G2sp[356]*Hs[113] + G2sp[596]*Hs[114] + G2sp[836]*Hs[115] + G2sp[1076]*Hs[116] + G2sp[1316]*Hs[117] + G2sp[1556]*Hs[118] + G2sp[1796]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[95]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[88]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[90]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[91]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[88]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[90]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[91]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[88]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[91]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[91]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[182]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[184] - kkappa*Gs[185] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[91])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[88] + Hs[91]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[88] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[88] + Gsp[17]*Hs[89] + Gsp[33]*Hs[90] + Gsp[49]*Hs[91] + Gsp[65]*Hs[92] + Gsp[81]*Hs[93] + Gsp[97]*Hs[94] + Gsp[113]*Hs[95]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[88] + Gsp[18]*Hs[89] + Gsp[34]*Hs[90] + Gsp[50]*Hs[91] + Gsp[66]*Hs[92] + Gsp[82]*Hs[93] + Gsp[98]*Hs[94] + Gsp[114]*Hs[95]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[88] + Gsp[20]*Hs[89] + Gsp[36]*Hs[90] + (rrhoz + Gsp[52])*Hs[91] + Gsp[68]*Hs[92] + Gsp[84]*Hs[93] + Gsp[100]*Hs[94] + Gsp[116]*Hs[95])))/pow(zbar,rrho) - kkappa*Gs[182]*yss[9]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nec_sp_s[77]=-(Pssp*Gs[182]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[182] + iiota*zbar*(Hs[88] + Hs[91])) + iiota*Pssp*zbar*(Hs[88] + Hs[91])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[78]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[177]*Gs[225] - pow(E,yss[7])*Pssp*Gs[183]*Gs[231] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[177] - pow(E,yss[7])*Gs[183])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nec_sp_s[79]=-(pow(E,yss[0])*Pssp*Gs[176]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[226] - pow(E,yss[3])*Pssp*Gs[179]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[90] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[90] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[91] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[91] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[178] + Hs[92])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[181]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[94]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[177] + Gs[183])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[178] + Hs[92])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[181]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[89])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[181]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[91]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[181]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[91]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[89]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[91]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[176]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[178] - pow(E,yss[3])*Gs[179] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[181] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] - pow(E,yss[2])*pbar*(Gs[178] + Hs[92]) - pow(E,yss[11])*ebar*Hs[94] - pphi*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]))*yss[5] + (zbar*Gs[181]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[89])/(1 + yss[5]) - (zbar*Hs[91]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nec_sp_s[80]=pow(E,yss[3])*Pssp*Gs[179]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[179] - pow(E,xss[0])*zbar*(Hs[88] + Hs[91])) - pow(E,xss[0])*Pssp*zbar*(Hs[88] + Hs[91])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[88] + Hs[91])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[81]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[182] + Hs[88] + Hs[91])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[181]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[181]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[89])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[181]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[91]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[181]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[91]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[89]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[91]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[177] + Gs[183])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[178] + Hs[92])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[181]) - Gs[186] + pow(E,xss[0])*kkappa*zbar*(Gs[182] + Hs[88] + Hs[91]) - (zbar*Gs[181]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[89])/(1 + yss[5]) + (zbar*Hs[91]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[177] + Gs[183]) + pow(E,yss[2])*pbar*(Gs[178] + Hs[92]))*(1 + yss[5])) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nec_sp_s[82]=((-1 + nnus)*Gs[185] + nnus*Gs[186])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nec_sp_s[83]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[181] - pow(E,bbar - xss[1])*ppsir*Hs[89] + Hs[93]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[89]*Hs[113] + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nec_sp_s[84]=pow(E,xss[0])*(-(Pssp*Gs[180]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[180] - Hs[88]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(Gs[228] - Hs[112]) + Pssp*Hs[88]*Hs[112]);
	Nec_sp_s[85]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[178]*Gs[226] + pow(E,yss[11])*Pssp*Gs[187]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[90] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[90] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[91] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[91] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[177]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[178] + pow(E,yss[11])*Gs[187] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[90] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[91] + pow(E,yss[2])*pbar*(Gs[178] + Hs[92])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[177]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[178]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[90]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[91]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[178] + Hs[92])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nec_sp_s[86]=(Pssp*zbar*(Gs[187] - Hs[91])*Hs[113] + Pssp*zbar*Hs[89]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[187] - Hs[91])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[188] - zbar*Hs[89] + zbar*(Gs[187] - Hs[91])*xss[1]) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[87]=(-(Pssp*zbar*Hs[91]*Hs[113]) - Pssp*zbar*Hs[89]*Hs[115] - Pssp*(-1 + zbar)*Gs[187]*Gs[235]*xss[1] - Pssp*zbar*Hs[91]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[89] + Hs[91]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[189]) + zbar*Hs[89] - (-1 + zbar)*Gs[187]*xss[1] + zbar*Hs[91]*xss[1]) + Pssp*zbar*Gs[187]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[88]=pow(E,yss[0] - yss[11])*Pssp*Gs[176]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[179]*Gs[227] - Pssp*Gs[187]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[187]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[176] + pow(E,yss[3])*Gs[179] - pow(E,yss[11])*Gs[187] + pow(E,yss[11])*ebar*Hs[94]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[176] + pow(E,yss[3])*Gs[179] - pow(E,yss[0])*Gs[187] - pow(E,yss[3])*Gs[187] - pow(E,yss[11])*ebar*Gs[187] + pow(E,yss[11])*Gs[190] + pow(E,yss[11])*ebar*Hs[94]))/pow(E,yss[11]) + ebar*Pssp*Hs[94]*Hs[118] - (Pssp*Gs[187]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[185] + dP1ssp*Gs[186])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nec_sp_s[89]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[91]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[185]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[185]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[91]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*Hs[88]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[89]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[90]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[91]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[92]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[93]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[94]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[95]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[91]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[56]*Hs[91] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[191] + pow(zbar,rrho)*(-Gs[185] + (-(rrho*rrhoz) + Gsp[56])*Hs[91]*yss[9] + (Gsp[8]*Hs[88] + Gsp[24]*Hs[89] + Gsp[40]*Hs[90] + Gsp[72]*Hs[92] + Gsp[88]*Hs[93] + Gsp[104]*Hs[94] + Gsp[120]*Hs[95])*yss[9])) + (dP2ssp*Gs[185] + dP1ssp*Gs[186])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nec_sp_s[90]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[90]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[114];
	Nec_sp_s[91]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[91]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[115];
	Nec_sp_s[92]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[92]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[116];
	Nec_sp_s[93]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[95]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[119];
	Nec_sp_s[94]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[94]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[118];
	Nec_sp_s[95]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(ssigmar - Hs[93]) - (dP2ssp*Gs[185] + dP1ssp*Gs[186])*Hs[117];
	Nec_sp_s[96]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[192]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[193]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[200]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[103] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193])) - pow(E,yss[8])*Gs[200] + Hs[103]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[192] - pow(pow(E,yss[1]),oomega)*Gs[193])*Hs[119] + (Pssp*Hs[103]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nec_sp_s[97]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[226] - (pbar*pphi*Pssp*Gs[201]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[197]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[98] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[98] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[99] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[99] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[115] + (pbar*pphi*Pssp*Gs[201]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[200]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[200]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[197]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[200]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[100]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[100]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[193]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[194] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[99] - pbar*Hs[100]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nec_sp_s[98]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[193]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[201]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[197]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[98] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[99] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[99] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[201]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[200]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[200]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[197]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[200]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[199]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[199]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[193]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[193] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[194] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[98] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[99] - pow(E,yss[7])*pphi*Gs[199]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[197]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[201] - Gs[200]*yss[9]))) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nec_sp_s[99]=-(pow(E,yss[8])*Pssp*Gs[200]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[99])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[197]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[197]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[99]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[96]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[97]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[98]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[99]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[100]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[101]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[102]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[103]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[99]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[197])/pow(zbar,rrho) - pow(E,yss[8])*Gs[200] + Gs[201] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[99]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nec_sp_s[100]=-(kkappa*Pssp*Gs[201]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[200]*Gs[232] - kkappa*Pssp*Gs[198]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[96]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[96]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[98]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[99]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[96]*Hs[114] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[98]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[99]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[96]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[98]*Hs[115] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[99]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[99]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[200]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[96] + Hs[99])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[96]*(G2sp[225] + G2sp[1]*Hs[112] + G2sp[17]*Hs[113] + G2sp[33]*Hs[114] + G2sp[49]*Hs[115] + G2sp[65]*Hs[116] + G2sp[81]*Hs[117] + G2sp[97]*Hs[118] + G2sp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[96]*(G2sp[226] + G2sp[2]*Hs[112] + G2sp[18]*Hs[113] + G2sp[34]*Hs[114] + G2sp[50]*Hs[115] + G2sp[66]*Hs[116] + G2sp[82]*Hs[117] + G2sp[98]*Hs[118] + G2sp[114]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[96]*(G2sp[228] + G2sp[4]*Hs[112] + G2sp[20]*Hs[113] + G2sp[36]*Hs[114] + G2sp[52]*Hs[115] + G2sp[68]*Hs[116] + G2sp[84]*Hs[117] + G2sp[100]*Hs[118] + G2sp[116]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[96]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[97]*(G2sp[465] + G2sp[17]*Hs[112] + G2sp[257]*Hs[113] + G2sp[273]*Hs[114] + G2sp[289]*Hs[115] + G2sp[305]*Hs[116] + G2sp[321]*Hs[117] + G2sp[337]*Hs[118] + G2sp[353]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[97]*(G2sp[466] + G2sp[18]*Hs[112] + G2sp[258]*Hs[113] + G2sp[274]*Hs[114] + G2sp[290]*Hs[115] + G2sp[306]*Hs[116] + G2sp[322]*Hs[117] + G2sp[338]*Hs[118] + G2sp[354]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[97]*(G2sp[468] + G2sp[20]*Hs[112] + G2sp[260]*Hs[113] + G2sp[276]*Hs[114] + G2sp[292]*Hs[115] + G2sp[308]*Hs[116] + G2sp[324]*Hs[117] + G2sp[340]*Hs[118] + G2sp[356]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[97]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[98]*(G2sp[705] + G2sp[33]*Hs[112] + G2sp[273]*Hs[113] + G2sp[513]*Hs[114] + G2sp[529]*Hs[115] + G2sp[545]*Hs[116] + G2sp[561]*Hs[117] + G2sp[577]*Hs[118] + G2sp[593]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[98]*(G2sp[706] + G2sp[34]*Hs[112] + G2sp[274]*Hs[113] + G2sp[514]*Hs[114] + G2sp[530]*Hs[115] + G2sp[546]*Hs[116] + G2sp[562]*Hs[117] + G2sp[578]*Hs[118] + G2sp[594]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[98]*(G2sp[708] + G2sp[36]*Hs[112] + G2sp[276]*Hs[113] + G2sp[516]*Hs[114] + G2sp[532]*Hs[115] + G2sp[548]*Hs[116] + G2sp[564]*Hs[117] + G2sp[580]*Hs[118] + G2sp[596]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[98]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[99]*(G2sp[945] + G2sp[49]*Hs[112] + G2sp[289]*Hs[113] + G2sp[529]*Hs[114] + G2sp[769]*Hs[115] + G2sp[785]*Hs[116] + G2sp[801]*Hs[117] + G2sp[817]*Hs[118] + G2sp[833]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[99]*(G2sp[946] + G2sp[50]*Hs[112] + G2sp[290]*Hs[113] + G2sp[530]*Hs[114] + G2sp[770]*Hs[115] + G2sp[786]*Hs[116] + G2sp[802]*Hs[117] + G2sp[818]*Hs[118] + G2sp[834]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[99]*(G2sp[948] + G2sp[52]*Hs[112] + G2sp[292]*Hs[113] + G2sp[532]*Hs[114] + G2sp[772]*Hs[115] + G2sp[788]*Hs[116] + G2sp[804]*Hs[117] + G2sp[820]*Hs[118] + G2sp[836]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[99]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[100]*(G2sp[1185] + G2sp[65]*Hs[112] + G2sp[305]*Hs[113] + G2sp[545]*Hs[114] + G2sp[785]*Hs[115] + G2sp[1025]*Hs[116] + G2sp[1041]*Hs[117] + G2sp[1057]*Hs[118] + G2sp[1073]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[100]*(G2sp[1186] + G2sp[66]*Hs[112] + G2sp[306]*Hs[113] + G2sp[546]*Hs[114] + G2sp[786]*Hs[115] + G2sp[1026]*Hs[116] + G2sp[1042]*Hs[117] + G2sp[1058]*Hs[118] + G2sp[1074]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[100]*(G2sp[1188] + G2sp[68]*Hs[112] + G2sp[308]*Hs[113] + G2sp[548]*Hs[114] + G2sp[788]*Hs[115] + G2sp[1028]*Hs[116] + G2sp[1044]*Hs[117] + G2sp[1060]*Hs[118] + G2sp[1076]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[100]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[101]*(G2sp[1425] + G2sp[81]*Hs[112] + G2sp[321]*Hs[113] + G2sp[561]*Hs[114] + G2sp[801]*Hs[115] + G2sp[1041]*Hs[116] + G2sp[1281]*Hs[117] + G2sp[1297]*Hs[118] + G2sp[1313]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[101]*(G2sp[1426] + G2sp[82]*Hs[112] + G2sp[322]*Hs[113] + G2sp[562]*Hs[114] + G2sp[802]*Hs[115] + G2sp[1042]*Hs[116] + G2sp[1282]*Hs[117] + G2sp[1298]*Hs[118] + G2sp[1314]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[101]*(G2sp[1428] + G2sp[84]*Hs[112] + G2sp[324]*Hs[113] + G2sp[564]*Hs[114] + G2sp[804]*Hs[115] + G2sp[1044]*Hs[116] + G2sp[1284]*Hs[117] + G2sp[1300]*Hs[118] + G2sp[1316]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[101]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[102]*(G2sp[1665] + G2sp[97]*Hs[112] + G2sp[337]*Hs[113] + G2sp[577]*Hs[114] + G2sp[817]*Hs[115] + G2sp[1057]*Hs[116] + G2sp[1297]*Hs[117] + G2sp[1537]*Hs[118] + G2sp[1553]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[102]*(G2sp[1666] + G2sp[98]*Hs[112] + G2sp[338]*Hs[113] + G2sp[578]*Hs[114] + G2sp[818]*Hs[115] + G2sp[1058]*Hs[116] + G2sp[1298]*Hs[117] + G2sp[1538]*Hs[118] + G2sp[1554]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[102]*(G2sp[1668] + G2sp[100]*Hs[112] + G2sp[340]*Hs[113] + G2sp[580]*Hs[114] + G2sp[820]*Hs[115] + G2sp[1060]*Hs[116] + G2sp[1300]*Hs[117] + G2sp[1540]*Hs[118] + G2sp[1556]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[102]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[103]*(G2sp[1905] + G2sp[113]*Hs[112] + G2sp[353]*Hs[113] + G2sp[593]*Hs[114] + G2sp[833]*Hs[115] + G2sp[1073]*Hs[116] + G2sp[1313]*Hs[117] + G2sp[1553]*Hs[118] + G2sp[1793]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[103]*(G2sp[1906] + G2sp[114]*Hs[112] + G2sp[354]*Hs[113] + G2sp[594]*Hs[114] + G2sp[834]*Hs[115] + G2sp[1074]*Hs[116] + G2sp[1314]*Hs[117] + G2sp[1554]*Hs[118] + G2sp[1794]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[103]*(G2sp[1908] + G2sp[116]*Hs[112] + G2sp[356]*Hs[113] + G2sp[596]*Hs[114] + G2sp[836]*Hs[115] + G2sp[1076]*Hs[116] + G2sp[1316]*Hs[117] + G2sp[1556]*Hs[118] + G2sp[1796]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[103]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[96]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[98]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[99]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[96]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[98]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[99]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[96]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[99]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[99]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[198]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[200] - kkappa*Gs[201] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[99])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[96] + Hs[99]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[96] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[96] + Gsp[17]*Hs[97] + Gsp[33]*Hs[98] + Gsp[49]*Hs[99] + Gsp[65]*Hs[100] + Gsp[81]*Hs[101] + Gsp[97]*Hs[102] + Gsp[113]*Hs[103]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[96] + Gsp[18]*Hs[97] + Gsp[34]*Hs[98] + Gsp[50]*Hs[99] + Gsp[66]*Hs[100] + Gsp[82]*Hs[101] + Gsp[98]*Hs[102] + Gsp[114]*Hs[103]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[96] + Gsp[20]*Hs[97] + Gsp[36]*Hs[98] + (rrhoz + Gsp[52])*Hs[99] + Gsp[68]*Hs[100] + Gsp[84]*Hs[101] + Gsp[100]*Hs[102] + Gsp[116]*Hs[103])))/pow(zbar,rrho) - kkappa*Gs[198]*yss[9]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nec_sp_s[101]=-(Pssp*Gs[198]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[198] + iiota*zbar*(Hs[96] + Hs[99])) + iiota*Pssp*zbar*(Hs[96] + Hs[99])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[102]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[193]*Gs[225] - pow(E,yss[7])*Pssp*Gs[199]*Gs[231] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[193] - pow(E,yss[7])*Gs[199])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nec_sp_s[103]=-(pow(E,yss[0])*Pssp*Gs[192]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[226] - pow(E,yss[3])*Pssp*Gs[195]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[98] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[99] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[99] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[194] + Hs[100])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[197]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[102]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[193] + Gs[199])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[194] + Hs[100])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[197]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[97])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[197]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[99]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[197]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[99]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[97]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[99]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[192]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[193] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[194] - pow(E,yss[3])*Gs[195] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[197] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[99] - pow(E,yss[2])*pbar*(Gs[194] + Hs[100]) - pow(E,yss[11])*ebar*Hs[102] - pphi*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100]))*yss[5] + (zbar*Gs[197]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[97])/(1 + yss[5]) - (zbar*Hs[99]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nec_sp_s[104]=pow(E,yss[3])*Pssp*Gs[195]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[195] - pow(E,xss[0])*zbar*(Hs[96] + Hs[99])) - pow(E,xss[0])*Pssp*zbar*(Hs[96] + Hs[99])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[96] + Hs[99])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[105]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[198] + Hs[96] + Hs[99])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[197]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[197]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[97])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[197]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[99]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[197]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[99]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[97]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[99]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[193] + Gs[199])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[194] + Hs[100])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[197]) - Gs[202] + pow(E,xss[0])*kkappa*zbar*(Gs[198] + Hs[96] + Hs[99]) - (zbar*Gs[197]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[97])/(1 + yss[5]) + (zbar*Hs[99]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[193] + Gs[199]) + pow(E,yss[2])*pbar*(Gs[194] + Hs[100]))*(1 + yss[5])) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nec_sp_s[106]=((-1 + nnus)*Gs[201] + nnus*Gs[202])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nec_sp_s[107]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[197] - pow(E,bbar - xss[1])*ppsir*Hs[97] + Hs[101]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[97]*Hs[113] + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nec_sp_s[108]=pow(E,xss[0])*(-(Pssp*Gs[196]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[196] - Hs[96]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(Gs[228] - Hs[112]) + Pssp*Hs[96]*Hs[112]);
	Nec_sp_s[109]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[194]*Gs[226] + pow(E,yss[11])*Pssp*Gs[203]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[98] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[98] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[99] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[99] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[193]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[194] + pow(E,yss[11])*Gs[203] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[98] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[99] + pow(E,yss[2])*pbar*(Gs[194] + Hs[100])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[193]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[194]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[98]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[99]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[194] + Hs[100])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nec_sp_s[110]=(Pssp*zbar*(Gs[203] - Hs[99])*Hs[113] + Pssp*zbar*Hs[97]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[203] - Hs[99])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[204] - zbar*Hs[97] + zbar*(Gs[203] - Hs[99])*xss[1]) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[111]=(-(Pssp*zbar*Hs[99]*Hs[113]) - Pssp*zbar*Hs[97]*Hs[115] - Pssp*(-1 + zbar)*Gs[203]*Gs[235]*xss[1] - Pssp*zbar*Hs[99]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[97] + Hs[99]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[205]) + zbar*Hs[97] - (-1 + zbar)*Gs[203]*xss[1] + zbar*Hs[99]*xss[1]) + Pssp*zbar*Gs[203]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[112]=pow(E,yss[0] - yss[11])*Pssp*Gs[192]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[195]*Gs[227] - Pssp*Gs[203]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[203]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[192] + pow(E,yss[3])*Gs[195] - pow(E,yss[11])*Gs[203] + pow(E,yss[11])*ebar*Hs[102]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[192] + pow(E,yss[3])*Gs[195] - pow(E,yss[0])*Gs[203] - pow(E,yss[3])*Gs[203] - pow(E,yss[11])*ebar*Gs[203] + pow(E,yss[11])*Gs[206] + pow(E,yss[11])*ebar*Hs[102]))/pow(E,yss[11]) + ebar*Pssp*Hs[102]*Hs[118] - (Pssp*Gs[203]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[201] + dP1ssp*Gs[202])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nec_sp_s[113]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[99]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[201]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[201]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[99]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*Hs[96]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[97]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[98]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[99]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[100]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[101]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[102]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[103]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[99]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[56]*Hs[99] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[207] + pow(zbar,rrho)*(-Gs[201] + (-(rrho*rrhoz) + Gsp[56])*Hs[99]*yss[9] + (Gsp[8]*Hs[96] + Gsp[24]*Hs[97] + Gsp[40]*Hs[98] + Gsp[72]*Hs[100] + Gsp[88]*Hs[101] + Gsp[104]*Hs[102] + Gsp[120]*Hs[103])*yss[9])) + (dP2ssp*Gs[201] + dP1ssp*Gs[202])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nec_sp_s[114]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[98]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[114];
	Nec_sp_s[115]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[99]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[115];
	Nec_sp_s[116]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[100]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[116];
	Nec_sp_s[117]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[103]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[119];
	Nec_sp_s[118]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(ssigmae - Hs[102]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[118];
	Nec_sp_s[119]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[101]) - (dP2ssp*Gs[201] + dP1ssp*Gs[202])*Hs[117];
	Nec_sp_s[120]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[208]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[209]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[208] - pow(pow(E,yss[1]),oomega)*Gs[209])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[216]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[111] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[208] - pow(pow(E,yss[1]),oomega)*Gs[209])) - pow(E,yss[8])*Gs[216] + Hs[111]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[208] - pow(pow(E,yss[1]),oomega)*Gs[209])*Hs[119] + (Pssp*Hs[111]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nec_sp_s[121]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[226] - (pbar*pphi*Pssp*Gs[217]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[213]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[106] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[106] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[107] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[107] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[115] + (pbar*pphi*Pssp*Gs[217]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[216]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[216]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[213]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[216]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[108]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[108]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[209]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[210] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[106] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[107] - pbar*Hs[108]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nec_sp_s[122]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[209]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[217]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[213]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[106] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[107] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[107] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[217]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[216]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[216]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[213]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[216]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[215]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[215]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[209]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[209] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[210] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[106] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[107] - pow(E,yss[7])*pphi*Gs[215]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[213]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[217] - Gs[216]*yss[9]))) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nec_sp_s[123]=-(pow(E,yss[8])*Pssp*Gs[216]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[107])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[213]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[213]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[107]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[104]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[105]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[106]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[107]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[108]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[109]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[110]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[111]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[107]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[213])/pow(zbar,rrho) - pow(E,yss[8])*Gs[216] + Gs[217] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[107]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nec_sp_s[124]=-(kkappa*Pssp*Gs[217]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[216]*Gs[232] - kkappa*Pssp*Gs[214]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[104]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[104]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[106]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[107]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111])*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[104]*Hs[114] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[106]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[107]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[104]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[106]*Hs[115] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[107]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[107]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[104] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[216]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[104] + Hs[107])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[104]*(G2sp[225] + G2sp[1]*Hs[112] + G2sp[17]*Hs[113] + G2sp[33]*Hs[114] + G2sp[49]*Hs[115] + G2sp[65]*Hs[116] + G2sp[81]*Hs[117] + G2sp[97]*Hs[118] + G2sp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[104]*(G2sp[226] + G2sp[2]*Hs[112] + G2sp[18]*Hs[113] + G2sp[34]*Hs[114] + G2sp[50]*Hs[115] + G2sp[66]*Hs[116] + G2sp[82]*Hs[117] + G2sp[98]*Hs[118] + G2sp[114]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[104]*(G2sp[228] + G2sp[4]*Hs[112] + G2sp[20]*Hs[113] + G2sp[36]*Hs[114] + G2sp[52]*Hs[115] + G2sp[68]*Hs[116] + G2sp[84]*Hs[117] + G2sp[100]*Hs[118] + G2sp[116]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[104]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[105]*(G2sp[465] + G2sp[17]*Hs[112] + G2sp[257]*Hs[113] + G2sp[273]*Hs[114] + G2sp[289]*Hs[115] + G2sp[305]*Hs[116] + G2sp[321]*Hs[117] + G2sp[337]*Hs[118] + G2sp[353]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[105]*(G2sp[466] + G2sp[18]*Hs[112] + G2sp[258]*Hs[113] + G2sp[274]*Hs[114] + G2sp[290]*Hs[115] + G2sp[306]*Hs[116] + G2sp[322]*Hs[117] + G2sp[338]*Hs[118] + G2sp[354]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[105]*(G2sp[468] + G2sp[20]*Hs[112] + G2sp[260]*Hs[113] + G2sp[276]*Hs[114] + G2sp[292]*Hs[115] + G2sp[308]*Hs[116] + G2sp[324]*Hs[117] + G2sp[340]*Hs[118] + G2sp[356]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[105]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[106]*(G2sp[705] + G2sp[33]*Hs[112] + G2sp[273]*Hs[113] + G2sp[513]*Hs[114] + G2sp[529]*Hs[115] + G2sp[545]*Hs[116] + G2sp[561]*Hs[117] + G2sp[577]*Hs[118] + G2sp[593]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[106]*(G2sp[706] + G2sp[34]*Hs[112] + G2sp[274]*Hs[113] + G2sp[514]*Hs[114] + G2sp[530]*Hs[115] + G2sp[546]*Hs[116] + G2sp[562]*Hs[117] + G2sp[578]*Hs[118] + G2sp[594]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[106]*(G2sp[708] + G2sp[36]*Hs[112] + G2sp[276]*Hs[113] + G2sp[516]*Hs[114] + G2sp[532]*Hs[115] + G2sp[548]*Hs[116] + G2sp[564]*Hs[117] + G2sp[580]*Hs[118] + G2sp[596]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[106]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[107]*(G2sp[945] + G2sp[49]*Hs[112] + G2sp[289]*Hs[113] + G2sp[529]*Hs[114] + G2sp[769]*Hs[115] + G2sp[785]*Hs[116] + G2sp[801]*Hs[117] + G2sp[817]*Hs[118] + G2sp[833]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[107]*(G2sp[946] + G2sp[50]*Hs[112] + G2sp[290]*Hs[113] + G2sp[530]*Hs[114] + G2sp[770]*Hs[115] + G2sp[786]*Hs[116] + G2sp[802]*Hs[117] + G2sp[818]*Hs[118] + G2sp[834]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[107]*(G2sp[948] + G2sp[52]*Hs[112] + G2sp[292]*Hs[113] + G2sp[532]*Hs[114] + G2sp[772]*Hs[115] + G2sp[788]*Hs[116] + G2sp[804]*Hs[117] + G2sp[820]*Hs[118] + G2sp[836]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[107]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[108]*(G2sp[1185] + G2sp[65]*Hs[112] + G2sp[305]*Hs[113] + G2sp[545]*Hs[114] + G2sp[785]*Hs[115] + G2sp[1025]*Hs[116] + G2sp[1041]*Hs[117] + G2sp[1057]*Hs[118] + G2sp[1073]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[108]*(G2sp[1186] + G2sp[66]*Hs[112] + G2sp[306]*Hs[113] + G2sp[546]*Hs[114] + G2sp[786]*Hs[115] + G2sp[1026]*Hs[116] + G2sp[1042]*Hs[117] + G2sp[1058]*Hs[118] + G2sp[1074]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[108]*(G2sp[1188] + G2sp[68]*Hs[112] + G2sp[308]*Hs[113] + G2sp[548]*Hs[114] + G2sp[788]*Hs[115] + G2sp[1028]*Hs[116] + G2sp[1044]*Hs[117] + G2sp[1060]*Hs[118] + G2sp[1076]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[108]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[109]*(G2sp[1425] + G2sp[81]*Hs[112] + G2sp[321]*Hs[113] + G2sp[561]*Hs[114] + G2sp[801]*Hs[115] + G2sp[1041]*Hs[116] + G2sp[1281]*Hs[117] + G2sp[1297]*Hs[118] + G2sp[1313]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[109]*(G2sp[1426] + G2sp[82]*Hs[112] + G2sp[322]*Hs[113] + G2sp[562]*Hs[114] + G2sp[802]*Hs[115] + G2sp[1042]*Hs[116] + G2sp[1282]*Hs[117] + G2sp[1298]*Hs[118] + G2sp[1314]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[109]*(G2sp[1428] + G2sp[84]*Hs[112] + G2sp[324]*Hs[113] + G2sp[564]*Hs[114] + G2sp[804]*Hs[115] + G2sp[1044]*Hs[116] + G2sp[1284]*Hs[117] + G2sp[1300]*Hs[118] + G2sp[1316]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[109]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[110]*(G2sp[1665] + G2sp[97]*Hs[112] + G2sp[337]*Hs[113] + G2sp[577]*Hs[114] + G2sp[817]*Hs[115] + G2sp[1057]*Hs[116] + G2sp[1297]*Hs[117] + G2sp[1537]*Hs[118] + G2sp[1553]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[110]*(G2sp[1666] + G2sp[98]*Hs[112] + G2sp[338]*Hs[113] + G2sp[578]*Hs[114] + G2sp[818]*Hs[115] + G2sp[1058]*Hs[116] + G2sp[1298]*Hs[117] + G2sp[1538]*Hs[118] + G2sp[1554]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[110]*(G2sp[1668] + G2sp[100]*Hs[112] + G2sp[340]*Hs[113] + G2sp[580]*Hs[114] + G2sp[820]*Hs[115] + G2sp[1060]*Hs[116] + G2sp[1300]*Hs[117] + G2sp[1540]*Hs[118] + G2sp[1556]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[110]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[111]*(G2sp[1905] + G2sp[113]*Hs[112] + G2sp[353]*Hs[113] + G2sp[593]*Hs[114] + G2sp[833]*Hs[115] + G2sp[1073]*Hs[116] + G2sp[1313]*Hs[117] + G2sp[1553]*Hs[118] + G2sp[1793]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[111]*(G2sp[1906] + G2sp[114]*Hs[112] + G2sp[354]*Hs[113] + G2sp[594]*Hs[114] + G2sp[834]*Hs[115] + G2sp[1074]*Hs[116] + G2sp[1314]*Hs[117] + G2sp[1554]*Hs[118] + G2sp[1794]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[111]*(G2sp[1908] + G2sp[116]*Hs[112] + G2sp[356]*Hs[113] + G2sp[596]*Hs[114] + G2sp[836]*Hs[115] + G2sp[1076]*Hs[116] + G2sp[1316]*Hs[117] + G2sp[1556]*Hs[118] + G2sp[1796]*Hs[119]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[111]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[104]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[106]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[107]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[104]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[106]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[107]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[104]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[107]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[104] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[107]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[214]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[216] - kkappa*Gs[217] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[107])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[104] + Hs[107]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[104] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[104] + Gsp[17]*Hs[105] + Gsp[33]*Hs[106] + Gsp[49]*Hs[107] + Gsp[65]*Hs[108] + Gsp[81]*Hs[109] + Gsp[97]*Hs[110] + Gsp[113]*Hs[111]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[104] + Gsp[18]*Hs[105] + Gsp[34]*Hs[106] + Gsp[50]*Hs[107] + Gsp[66]*Hs[108] + Gsp[82]*Hs[109] + Gsp[98]*Hs[110] + Gsp[114]*Hs[111]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[104] + Gsp[20]*Hs[105] + Gsp[36]*Hs[106] + (rrhoz + Gsp[52])*Hs[107] + Gsp[68]*Hs[108] + Gsp[84]*Hs[109] + Gsp[100]*Hs[110] + Gsp[116]*Hs[111])))/pow(zbar,rrho) - kkappa*Gs[214]*yss[9]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nec_sp_s[125]=-(Pssp*Gs[214]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[214] + iiota*zbar*(Hs[104] + Hs[107])) + iiota*Pssp*zbar*(Hs[104] + Hs[107])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[126]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[209]*Gs[225] - pow(E,yss[7])*Pssp*Gs[215]*Gs[231] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[209] - pow(E,yss[7])*Gs[215])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nec_sp_s[127]=-(pow(E,yss[0])*Pssp*Gs[208]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[226] - pow(E,yss[3])*Pssp*Gs[211]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[106] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[106] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[107] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[107] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[210] + Hs[108])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[213]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[110]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[209] + Gs[215])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[210] + Hs[108])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[213]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[105])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[213]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[107]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[213]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[107]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[105]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[107]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[208]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[209] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[210] - pow(E,yss[3])*Gs[211] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[213] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[106] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[107] - pow(E,yss[2])*pbar*(Gs[210] + Hs[108]) - pow(E,yss[11])*ebar*Hs[110] - pphi*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108]))*yss[5] + (zbar*Gs[213]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[105])/(1 + yss[5]) - (zbar*Hs[107]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nec_sp_s[128]=pow(E,yss[3])*Pssp*Gs[211]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[211] - pow(E,xss[0])*zbar*(Hs[104] + Hs[107])) - pow(E,xss[0])*Pssp*zbar*(Hs[104] + Hs[107])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[104] + Hs[107])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nec_sp_s[129]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[214] + Hs[104] + Hs[107])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[213]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[213]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[105])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[213]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[107]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[213]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[107]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[105]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[107]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[209] + Gs[215])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[210] + Hs[108])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[213]) - Gs[218] + pow(E,xss[0])*kkappa*zbar*(Gs[214] + Hs[104] + Hs[107]) - (zbar*Gs[213]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[105])/(1 + yss[5]) + (zbar*Hs[107]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[209] + Gs[215]) + pow(E,yss[2])*pbar*(Gs[210] + Hs[108]))*(1 + yss[5])) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nec_sp_s[130]=((-1 + nnus)*Gs[217] + nnus*Gs[218])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nec_sp_s[131]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[213] - pow(E,bbar - xss[1])*ppsir*Hs[105] + Hs[109]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[105]*Hs[113] + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nec_sp_s[132]=pow(E,xss[0])*(-(Pssp*Gs[212]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[212] - Hs[104]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(Gs[228] - Hs[112]) + Pssp*Hs[104]*Hs[112]);
	Nec_sp_s[133]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[210]*Gs[226] + pow(E,yss[11])*Pssp*Gs[219]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[106] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[106] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[107] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[107] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[209]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[210] + pow(E,yss[11])*Gs[219] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[106] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[107] + pow(E,yss[2])*pbar*(Gs[210] + Hs[108])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[209]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[210]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[106]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[107]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[210] + Hs[108])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nec_sp_s[134]=(Pssp*zbar*(Gs[219] - Hs[107])*Hs[113] + Pssp*zbar*Hs[105]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[219] - Hs[107])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[220] - zbar*Hs[105] + zbar*(Gs[219] - Hs[107])*xss[1]) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[135]=(-(Pssp*zbar*Hs[107]*Hs[113]) - Pssp*zbar*Hs[105]*Hs[115] - Pssp*(-1 + zbar)*Gs[219]*Gs[235]*xss[1] - Pssp*zbar*Hs[107]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[105] + Hs[107]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[221]) + zbar*Hs[105] - (-1 + zbar)*Gs[219]*xss[1] + zbar*Hs[107]*xss[1]) + Pssp*zbar*Gs[219]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nec_sp_s[136]=pow(E,yss[0] - yss[11])*Pssp*Gs[208]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[211]*Gs[227] - Pssp*Gs[219]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[219]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[208] + pow(E,yss[3])*Gs[211] - pow(E,yss[11])*Gs[219] + pow(E,yss[11])*ebar*Hs[110]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[208] + pow(E,yss[3])*Gs[211] - pow(E,yss[0])*Gs[219] - pow(E,yss[3])*Gs[219] - pow(E,yss[11])*ebar*Gs[219] + pow(E,yss[11])*Gs[222] + pow(E,yss[11])*ebar*Hs[110]))/pow(E,yss[11]) + ebar*Pssp*Hs[110]*Hs[118] - (Pssp*Gs[219]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[217] + dP1ssp*Gs[218])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nec_sp_s[137]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[107]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[217]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[217]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[107]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*Hs[104]*(G2sp[232] + G2sp[8]*Hs[112] + G2sp[24]*Hs[113] + G2sp[40]*Hs[114] + G2sp[56]*Hs[115] + G2sp[72]*Hs[116] + G2sp[88]*Hs[117] + G2sp[104]*Hs[118] + G2sp[120]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[105]*(G2sp[472] + G2sp[24]*Hs[112] + G2sp[264]*Hs[113] + G2sp[280]*Hs[114] + G2sp[296]*Hs[115] + G2sp[312]*Hs[116] + G2sp[328]*Hs[117] + G2sp[344]*Hs[118] + G2sp[360]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[106]*(G2sp[712] + G2sp[40]*Hs[112] + G2sp[280]*Hs[113] + G2sp[520]*Hs[114] + G2sp[536]*Hs[115] + G2sp[552]*Hs[116] + G2sp[568]*Hs[117] + G2sp[584]*Hs[118] + G2sp[600]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[107]*(G2sp[952] + G2sp[56]*Hs[112] + G2sp[296]*Hs[113] + G2sp[536]*Hs[114] + G2sp[776]*Hs[115] + G2sp[792]*Hs[116] + G2sp[808]*Hs[117] + G2sp[824]*Hs[118] + G2sp[840]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[108]*(G2sp[1192] + G2sp[72]*Hs[112] + G2sp[312]*Hs[113] + G2sp[552]*Hs[114] + G2sp[792]*Hs[115] + G2sp[1032]*Hs[116] + G2sp[1048]*Hs[117] + G2sp[1064]*Hs[118] + G2sp[1080]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[109]*(G2sp[1432] + G2sp[88]*Hs[112] + G2sp[328]*Hs[113] + G2sp[568]*Hs[114] + G2sp[808]*Hs[115] + G2sp[1048]*Hs[116] + G2sp[1288]*Hs[117] + G2sp[1304]*Hs[118] + G2sp[1320]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[110]*(G2sp[1672] + G2sp[104]*Hs[112] + G2sp[344]*Hs[113] + G2sp[584]*Hs[114] + G2sp[824]*Hs[115] + G2sp[1064]*Hs[116] + G2sp[1304]*Hs[117] + G2sp[1544]*Hs[118] + G2sp[1560]*Hs[119])*yss[9] + Pssp*pow(zbar,rrho)*Hs[111]*(G2sp[1912] + G2sp[120]*Hs[112] + G2sp[360]*Hs[113] + G2sp[600]*Hs[114] + G2sp[840]*Hs[115] + G2sp[1080]*Hs[116] + G2sp[1320]*Hs[117] + G2sp[1560]*Hs[118] + G2sp[1800]*Hs[119])*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[107]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[56]*Hs[107] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[223] + pow(zbar,rrho)*(-Gs[217] + (-(rrho*rrhoz) + Gsp[56])*Hs[107]*yss[9] + (Gsp[8]*Hs[104] + Gsp[24]*Hs[105] + Gsp[40]*Hs[106] + Gsp[72]*Hs[108] + Gsp[88]*Hs[109] + Gsp[104]*Hs[110] + Gsp[120]*Hs[111])*yss[9])) + (dP2ssp*Gs[217] + dP1ssp*Gs[218])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nec_sp_s[138]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[106]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[114];
	Nec_sp_s[139]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[107]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[115];
	Nec_sp_s[140]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[108]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[116];
	Nec_sp_s[141]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(ssigmad - Hs[111]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[119];
	Nec_sp_s[142]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[110]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[118];
	Nec_sp_s[143]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[109]) - (dP2ssp*Gs[217] + dP1ssp*Gs[218])*Hs[117];

}
